#version 410
out vec4 FragColor;
in vec2 TexCoords;

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float intensity;

void main()
{
	vec3 color = texture(colortex0, TexCoords).rgb;
	float depth = texture(depthtex0, TexCoords).r;

	depth = (depth - 0.45) * 10;

	color = mix(color, vec3(depth), intensity);

	FragColor = vec4(color, 1.0);
}