/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.CloudQuality;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderHelper;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderExternal;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.shader.framebuffer.FrameBuffer;
import net.minecraft.client.render.shader.framebuffer.FrameBufferSingleSample;
import net.minecraft.client.render.shader.framebuffer.FrameBufferTextureSingleSample;
import net.minecraft.client.render.shader.framebuffer.RenderBufferSingleSample;
import net.minecraft.core.block.material.Materials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class ShadersRenderer
implements Renderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    @Nullable
    protected FrameBuffer worldFrameBuffer = null;
    @Nullable
    protected FrameBuffer gameFrameBuffer = null;
    protected final Shader postShader = new Shader();
    protected final Shader finalShader = new Shader();
    protected ShaderProvider internal = new ShaderProviderInternal("/shaders/");
    public int fbWidth;
    public int fbHeight;
    public int renderWidth;
    public int renderHeight;

    public ShadersRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @Override
    public void beginRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre begin render game");
        this.setupFramebuffer();
        assert (this.worldFrameBuffer != null);
        assert (this.gameFrameBuffer != null);
        if (this.finalShader.isEnabled()) {
            this.gameFrameBuffer.bind();
        } else {
            this.gameFrameBuffer.unbind();
        }
        GL41.glUseProgram(0);
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        OpenGLHelper.checkError("begin render game");
    }

    @Override
    public void endRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre end render game");
        assert (this.gameFrameBuffer != null);
        this.gameFrameBuffer.blit();
        @NotNull FrameBuffer outputBuffer = this.gameFrameBuffer.getOutputBuffer();
        if (this.finalShader.isEnabled()) {
            this.finalShader.bind();
            GL41.glActiveTexture(33984);
            Objects.requireNonNull(outputBuffer.getAttachment(FrameBuffer.AttachmentType.COLOR)).bindForOutput();
            this.finalShader.uniformInt("colortex0", 0);
            ShaderHelper.setUniforms(this.mc, this.finalShader, partialTicks);
        } else {
            GL41.glUseProgram(0);
            Objects.requireNonNull(outputBuffer.getAttachment(FrameBuffer.AttachmentType.COLOR)).bindForOutput();
        }
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        ShaderHelper.drawFullscreenRect();
        GL41.glUseProgram(0);
        OpenGLHelper.checkError("end render game");
    }

    @Override
    public void beginRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre begin render world");
        assert (this.worldFrameBuffer != null);
        this.setupFramebuffer();
        this.worldFrameBuffer.bind();
        GL41.glViewport(0, 0, this.renderWidth, this.renderHeight);
        GL41.glUseProgram(0);
        OpenGLHelper.checkError("begin render world");
    }

    @Override
    public void endRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre end render world");
        assert (this.worldFrameBuffer != null);
        assert (this.gameFrameBuffer != null);
        this.worldFrameBuffer.blit();
        @NotNull FrameBuffer outputBuffer = this.worldFrameBuffer.getOutputBuffer();
        if (this.postShader.isEnabled()) {
            this.postShader.bind();
            GL41.glActiveTexture(33984);
            Objects.requireNonNull(outputBuffer.getAttachment(FrameBuffer.AttachmentType.COLOR)).bindForOutput();
            this.postShader.uniformInt("colortex0", 0);
            GL41.glActiveTexture(33985);
            Objects.requireNonNull(outputBuffer.getAttachment(FrameBuffer.AttachmentType.DEPTH)).bindForOutput();
            this.postShader.uniformInt("depthtex0", 1);
            GL41.glActiveTexture(33984);
            this.mc.ppm.enabled = true;
            ShaderHelper.setUniforms(this.mc, this.postShader, partialTicks);
            this.mc.ppm.enabled = false;
        } else {
            GL41.glUseProgram(0);
            Objects.requireNonNull(outputBuffer.getAttachment(FrameBuffer.AttachmentType.COLOR)).bindForOutput();
        }
        if (this.finalShader.isEnabled()) {
            this.gameFrameBuffer.bind();
        } else {
            this.gameFrameBuffer.unbind();
        }
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        ShaderHelper.drawFullscreenRect();
        LightmapHelper.instance.enableLightmapRendering();
        GL41.glUseProgram(0);
        OpenGLHelper.checkError("end render world");
    }

    @Override
    public void beginRenderClouds(float partialTicks) {
        if (((Boolean)GameSettings.CLOUDS.value).booleanValue() && GameSettings.CLOUD_QUALITY.value == CloudQuality.FANCY && Shaders.CLOUDS.isEnabled()) {
            OpenGLHelper.checkError("pre setup clouds");
            Shaders.CLOUDS.bind();
            int isEyeInLiquid = CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.LAVA, partialTicks) ? 2 : (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTicks) ? 1 : 0);
            GL41.glUniform1i(Shaders.CLOUDS.getUniform("isEyeInLiquid"), isEyeInLiquid);
            GL41.glUseProgram(0);
            OpenGLHelper.checkError("setup clouds");
        }
    }

    @Override
    public void endRenderClouds(float partialTicks) {
    }

    @Override
    public void beginRenderParticles(float partialTick) {
    }

    @Override
    public void endRenderParticles(float partialTicks) {
    }

    public void setupFramebuffer() {
        double renderScale = (float)((RenderScale)((Object)GameSettings.RENDER_SCALE.value)).scale;
        int scaledWidth = (int)(renderScale * (double)this.mc.gameWindow.getWidthPixels());
        int scaledHeight = (int)(renderScale * (double)this.mc.gameWindow.getHeightPixels());
        if (this.worldFrameBuffer == null || this.gameFrameBuffer == null || this.fbWidth != this.mc.gameWindow.getWidthPixels() || this.fbHeight != this.mc.gameWindow.getHeightPixels() || this.renderWidth != scaledWidth || this.renderHeight != scaledHeight) {
            this.fbWidth = this.mc.gameWindow.getWidthPixels();
            this.fbHeight = this.mc.gameWindow.getHeightPixels();
            this.renderWidth = scaledWidth;
            this.renderHeight = scaledHeight;
            boolean filtering = ((RenderScale)((Object)GameSettings.RENDER_SCALE.value)).useLinearFiltering;
            int filterMode = filtering ? 9729 : 9728;
            @NotNull Vector2i fbSize = new Vector2i(this.fbWidth, this.fbHeight);
            @NotNull Vector2i renderSize = new Vector2i(this.renderWidth, this.renderHeight);
            LOGGER.info("Display: {}, Render: {}", (Object)fbSize, (Object)renderSize);
            if (this.worldFrameBuffer != null) {
                this.worldFrameBuffer.delete();
            }
            if (this.gameFrameBuffer != null) {
                this.gameFrameBuffer.delete();
            }
            this.worldFrameBuffer = new FrameBufferSingleSample(new FrameBufferTextureSingleSample(6408, 36064, renderSize, parameters -> {
                parameters.set(10241, filterMode);
                parameters.set(10240, filterMode);
                parameters.set(10242, 33071);
                parameters.set(10243, 33071);
            }), new FrameBufferTextureSingleSample(6402, 36096, renderSize, parameters -> {
                parameters.set(10241, filterMode);
                parameters.set(10240, filterMode);
                parameters.set(10242, 33071);
                parameters.set(10243, 33071);
            }));
            this.gameFrameBuffer = new FrameBufferSingleSample(new FrameBufferTextureSingleSample(6408, 36064, fbSize, parameters -> {
                parameters.set(10241, filterMode);
                parameters.set(10240, filterMode);
                parameters.set(10242, 33071);
                parameters.set(10243, 33071);
            }), new RenderBufferSingleSample(35056, 33306, fbSize));
        }
    }

    @Override
    public void reload() {
        LOGGER.info("Reloading Shaders...");
        GL41.glUseProgram(0);
        GL41.glBindFramebuffer(36160, 0);
        OpenGLHelper.checkError("pre shader reload");
        this.postShader.delete();
        this.finalShader.delete();
        ShaderProvider shaderProvider = this.getShader();
        this.finalShader.compile(this.internal, "post/base");
        if (shaderProvider != null) {
            this.postShader.compile(shaderProvider, "post/post");
        }
        OpenGLHelper.checkError("shader reload");
    }

    @Override
    public void delete() {
        if (this.gameFrameBuffer != null) {
            this.gameFrameBuffer.delete();
            this.gameFrameBuffer = null;
        }
        if (this.worldFrameBuffer != null) {
            this.worldFrameBuffer.delete();
            this.worldFrameBuffer = null;
        }
    }

    @Override
    public void create() {
    }

    public ShaderProvider getShader() {
        String override = (String)GameSettings.SHADER_OVERRIDE.value;
        if (!override.isEmpty()) {
            return new ShaderProviderExternal(new File(override));
        }
        return this.internal;
    }

    @Nullable
    public FrameBuffer getWorldFrameBuffer() {
        return this.worldFrameBuffer;
    }

    @Nullable
    public FrameBuffer getGameFrameBuffer() {
        return this.gameFrameBuffer;
    }

    @Override
    public int getRenderWidth() {
        return this.renderWidth;
    }

    @Override
    public int getRenderHeight() {
        return this.renderHeight;
    }
}

