/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import net.minecraft.client.render.terrain.VertexConfig;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.slf4j.Logger;

public class VertexData<V extends VertexConfig<V>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public final V config;
    public int vertexCount;
    @NotNull
    private ByteBuffer buffer;

    public VertexData(@NotNull V config, int size) {
        this.config = config;
        this.buffer = BufferUtils.createByteBuffer(size);
    }

    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void resizeIfNeeded(int size) {
        if (this.buffer.capacity() < this.buffer.position() + size) {
            int newSize = this.buffer.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", this.getClass().getSimpleName(), this.buffer.capacity(), newSize);
            @NotNull ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }
}

