/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FlagRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindProvider;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererFlag
extends TileEntityRenderer<TileEntityFlag> {
    @NotNull
    private final FlagRenderer flagRenderer;
    public final Minecraft mc;
    private long lastTick;

    public TileEntityRendererFlag() {
        this.flagRenderer = new FlagRenderer(Minecraft.getMinecraft().textureManager);
        this.mc = Minecraft.getMinecraft();
        this.lastTick = 0L;
    }

    @Override
    public void doRender(@NotNull TessellatorGeneral tessellator, @NotNull TileEntityFlag tileEntity, double x, double y, double z, float partialTick) {
        WorldClient theWorld = Minecraft.getMinecraft().currentWorld;
        int blockUnder = theWorld.getBlockId(tileEntity.x, tileEntity.y - 1, tileEntity.z);
        boolean shortPole = blockUnder == Blocks.FLAG.id();
        WindProvider theWind = this.mc.currentWorld.getWorldType().getWindManager();
        float windDirection = theWind.getWindDirection(this.mc.currentWorld, 0.0f, 500.0f, 0.0f) * 360.0f;
        float windIntensity = theWind.getWindIntensity(this.mc.currentWorld, 0.0f, 500.0f, 0.0f);
        this.doRender(tessellator, tileEntity, x, y, z, partialTick, shortPole, windDirection, windIntensity);
    }

    public void doRender(@NotNull TessellatorGeneral tessellator, @NotNull TileEntityFlag tileEntityFlag, double x, double y, double z, float partialTick, boolean shortPole, float windDirection, float windIntensity) {
        StaticEntityModel flagModel;
        WorldClient theWorld = this.mc.currentWorld;
        if (theWorld.getWorldTime() != this.lastTick) {
            this.lastTick = theWorld.getWorldTime();
            this.flagRenderer.tick();
        }
        float swayInterpolated = (float)tileEntityFlag.sway + partialTick;
        float sway = (float)((double)swayInterpolated / 1.5 % (Math.PI * 2));
        sway = (float)(Math.sin(sway) * (double)windIntensity * 2.0);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x + 0.5f, (float)y, (float)z + 0.5f);
        GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
        this.bindTexture("/assets/minecraft/textures/entity/flag.png");
        StaticEntityModel staticEntityModel = flagModel = shortPole ? this.getModel("pole.short") : this.getModel("pole.long");
        if (shortPole) {
            GLRenderer.modelM4f().translate(0.0f, 18.0f, 0.0f);
        }
        flagModel.getTransform((String)"flag").rotY = (windDirection + sway) * MathHelper.DEG_TO_RAD;
        flagModel.render();
        flagModel.translateToBone("flag");
        this.bindTexture("/assets/minecraft/textures/entity/flag_ui.png");
        if (tileEntityFlag.getFlipped()) {
            this.getModel("cloth.mirror").render();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.ONE_MINUS_SRC_COLOR, BlendFactor.SRC_COLOR);
            this.renderDispatcher.textureManager.bindTexture(this.flagRenderer.getTexture(tileEntityFlag));
            this.getModel("cloth.mirror").render();
        } else {
            this.getModel("cloth").render();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.ONE_MINUS_SRC_COLOR, BlendFactor.SRC_COLOR);
            this.renderDispatcher.textureManager.bindTexture(this.flagRenderer.getTexture(tileEntityFlag));
            this.getModel("cloth").render();
        }
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
    }

    @Override
    public void onWorldChanged(World world) {
        this.flagRenderer.flushCaches();
    }
}

