/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemArmor<T extends IArmorShape>
extends Item
implements IArmorItem<T> {
    @NotNull
    private final ArmorMaterial material;
    @NotNull
    private final T armorShape;

    public ItemArmor(@NotNull String name, @NotNull String namespaceId, int id, @NotNull ArmorMaterial material, @NotNull T armorShape) {
        super(name, namespaceId, id);
        this.material = material;
        this.armorShape = armorShape;
        this.setMaxDamage((int)(armorShape.getDurabilityModifier() * (float)material.durability));
        this.maxStackSize = 1;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        T t = this.armorShape;
        if (!(t instanceof HumanArmorShape)) {
            return selfStack;
        }
        HumanArmorShape humanArmorShape = (HumanArmorShape)t;
        ItemStack currentArmorInSlot = player.getItemInArmorSlot(humanArmorShape);
        player.setItemInArmorSlot(humanArmorShape, selfStack);
        return currentArmorInSlot;
    }

    @Override
    @Nullable
    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    @Override
    @NotNull
    public T getArmorShape() {
        return this.armorShape;
    }
}

