/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.save.conversion.ChunkConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStack {
    public int stackSize;
    public int animationsToGo;
    public int itemID;
    private int metadata;
    @NotNull
    private CompoundTag tag;

    public ItemStack(@NotNull IItemConvertible item) {
        this(item, 1);
    }

    public ItemStack(@NotNull IItemConvertible item, int stackSize) {
        this(item, stackSize, 0);
    }

    public ItemStack(@NotNull IItemConvertible item, int stackSize, int metadata) {
        this(item.asItem(), stackSize, metadata);
    }

    public ItemStack(@NotNull Block<?> block) {
        this(block, 1);
    }

    public ItemStack(@NotNull Block<?> block, int stackSize) {
        this(block.id(), stackSize, 0);
    }

    public ItemStack(@NotNull Block<?> block, int stackSize, int metadata) {
        this(block.id(), stackSize, metadata);
    }

    public ItemStack(@NotNull Block<?> block, int stackSize, int metadata, @Nullable CompoundTag tag) {
        this(block.id(), stackSize, metadata, tag);
    }

    public ItemStack(@NotNull Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(@NotNull Item item, int stackSize) {
        this(item.id, stackSize, 0);
    }

    public ItemStack(@NotNull Item item, int stackSize, int metadata) {
        this(item.id, stackSize, metadata);
    }

    public ItemStack(@NotNull Item item, int stackSize, int metadata, @Nullable CompoundTag tag) {
        this(item.id, stackSize, metadata, tag);
    }

    public ItemStack(int itemID, int stackSize, int metadata) {
        this(itemID, stackSize, metadata, Item.itemsList[itemID].getDefaultTag());
    }

    public ItemStack(@NotNull ItemStack itemStack) {
        this.itemID = itemStack.itemID;
        this.metadata = itemStack.metadata;
        this.stackSize = itemStack.stackSize;
        this.tag = new CompoundTag(itemStack.tag);
        this.animationsToGo = 0;
    }

    public ItemStack(int itemID, int stackSize, int metadata, @Nullable CompoundTag tag) {
        this.itemID = itemID;
        this.stackSize = stackSize;
        this.metadata = metadata;
        if (tag == null) {
            tag = new CompoundTag();
        }
        this.tag = tag;
    }

    private ItemStack() {
        this.tag = new CompoundTag();
    }

    @NotNull
    public ItemStack splitStack(int i) {
        ItemStack itemStack = new ItemStack(this);
        itemStack.stackSize = i;
        this.stackSize -= i;
        return itemStack;
    }

    @NotNull
    public Item getItem() {
        return Objects.requireNonNull(Item.itemsList[this.itemID]);
    }

    @Deprecated
    public boolean useItem(@NotNull Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xHit, double yHit) {
        return this.useItemOnBlock(player, world, new TilePos(blockX, blockY, blockZ), side, xHit, yHit);
    }

    public boolean useItemOnBlock(@NotNull Player player, @NotNull World world, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (this.getItem().onUseOnBlock(this, world, player, blockPos, side, xHit, yHit)) {
            player.addStat(this.getItem().getStat("stat_used"), 1);
            return true;
        }
        return false;
    }

    public float getStrVsBlock(@NotNull Block<?> block) {
        return this.getItem().getStrVsBlock(this, block);
    }

    @Deprecated
    @Nullable
    public ItemStack useItemRightClick(@NotNull World world, @NotNull Player entityplayer) {
        return this.useItem(world, entityplayer);
    }

    @Nullable
    public ItemStack useItem(@NotNull World world, @NotNull Player player) {
        return this.getItem().onUse(this, world, player);
    }

    @NotNull
    public CompoundTag writeToNBT(@NotNull CompoundTag nbt) {
        nbt.putShort("id", (short)this.itemID);
        nbt.putByte("Count", (byte)this.stackSize);
        nbt.putShort("Damage", (short)this.metadata);
        nbt.putByte("Expanded", (byte)1);
        nbt.putInt("Version", 19134);
        if (!((Map)this.tag.getValue()).isEmpty()) {
            nbt.putCompound("Data", this.tag);
        }
        return nbt;
    }

    public void readFromNBT(@NotNull CompoundTag nbt) {
        this.itemID = nbt.getShort("id");
        this.stackSize = nbt.getByte("Count");
        this.metadata = nbt.getShort("Damage");
        byte expanded = nbt.getByte("Expanded");
        int version = nbt.getInteger("Version");
        if (expanded == 0 && this.itemID >= 256) {
            this.itemID += Blocks.blocksList.length - 256;
        }
        if (version < 19133 && this.itemID < Blocks.blocksList.length) {
            short[] id = new short[]{(short)this.itemID};
            byte[] meta = new byte[]{(byte)this.metadata};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id, meta);
            this.itemID = id[0];
            this.metadata = meta[0];
        }
        this.tag = nbt.getCompound("Data");
        if (this.tag == null) {
            this.tag = Item.itemsList[this.itemID].getDefaultTag();
        }
        if (this.tag.containsKey("color") && !this.tag.getBoolean("overrideColor")) {
            ((Map)this.tag.getValue()).remove("color");
        }
        if (this.tag.containsKey("name") && !this.tag.getBoolean("overrideName")) {
            ((Map)this.tag.getValue()).remove("name");
        }
        if (this.tag.getBoolean("overrideColor") && !this.tag.containsKey("color")) {
            System.err.println("Item has override color tag but no custom color!");
            Thread.dumpStack();
            ((Map)this.tag.getValue()).remove("overrideColor");
        }
        if (this.tag.getBoolean("overrideName") && (!this.tag.containsKey("name") || this.tag.getString("name").isEmpty())) {
            System.err.println("Item has override name tag but no custom name!");
            Thread.dumpStack();
            ((Map)this.tag.getValue()).remove("overrideName");
        }
        if (Item.itemsList[this.itemID] == null) {
            this.itemID = 0;
            this.stackSize = 0;
        }
        if (this.itemID == Blocks.CHEST_LEGACY.id()) {
            this.itemID = Blocks.CHEST_PLANKS_OAK.id();
        }
        if (this.itemID == Blocks.CHEST_LEGACY_PAINTED.id()) {
            this.itemID = Blocks.CHEST_PLANKS_OAK_PAINTED.id();
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit(this);
    }

    public int getMaxStackSize(Container inv) {
        return this.getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return this.getItem().getMaxDamageForStack(this) > 0;
    }

    @Deprecated
    public boolean getHasSubtypes() {
        return this.getItem().getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.metadata > 0;
    }

    public int getItemDamageForDisplay() {
        return this.metadata;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public void setMetadata(int metadata) {
        this.metadata = metadata;
    }

    public int getMaxDamage() {
        return this.getItem().getMaxDamageForStack(this);
    }

    public void damageItem(int damage, @Nullable Entity entity) {
        if (entity instanceof Player && !((Player)entity).getGamemode().hasToolDurability()) {
            return;
        }
        if (!this.isItemStackDamageable()) {
            return;
        }
        this.metadata += damage;
        if (this.metadata > this.getMaxDamage()) {
            if (entity instanceof Player) {
                ((Player)entity).addStat(this.getItem().getStat("stat_broken"), 1);
            }
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.metadata = 0;
        }
    }

    public void hitEntity(@NotNull Mob target, @NotNull Player attacker) {
        boolean flag = this.getItem().hitEntity(this, target, attacker);
        if (flag) {
            attacker.addStat(this.getItem().getStat("stat_used"), 1);
        }
    }

    @Deprecated
    public boolean beforeDestroyBlock(@NotNull World world, int id, int x, int y, int z, @NotNull Side side, @NotNull Player player) {
        return this.beforeBlockDestroyed(world, player, Objects.requireNonNull(Blocks.getBlock(id)), new TilePos(x, y, z), side);
    }

    public boolean beforeBlockDestroyed(@NotNull World world, @NotNull Player player, @NotNull Block<?> block, @NotNull TilePosc blockPos, @NotNull Side side) {
        return this.getItem().beforeBlockDestroyed(this, world, player, block, blockPos, side);
    }

    @Deprecated
    public void onDestroyBlock(@NotNull World world, int id, int x, int y, int z, @NotNull Side side, @NotNull Player entityplayer) {
        this.onBlockDestroyed(world, entityplayer, Objects.requireNonNull(Blocks.getBlock(id)), new TilePos(x, y, z), side);
    }

    public void onBlockDestroyed(@NotNull World world, @NotNull Player player, @NotNull Block<?> removedBlock, @NotNull TilePosc blockPos, @NotNull Side side) {
        if (this.getItem().onBlockDestroyed(this, world, player, removedBlock, blockPos, side)) {
            player.addStat(this.getItem().getStat("stat_used"), 1);
        }
    }

    public boolean consumeItem(@Nullable Player entityplayer) {
        if (this.stackSize <= 0) {
            return false;
        }
        if (entityplayer == null || entityplayer.getGamemode().hasBlockConsumption()) {
            --this.stackSize;
        }
        return true;
    }

    public int getDamageVsEntity(@NotNull Entity entity) {
        return this.getItem().getDamageVsEntity(this, entity);
    }

    public boolean canHarvestBlock(@NotNull Mob mob, @NotNull Block<?> block) {
        return this.getItem().canHarvestBlock(this, mob, block);
    }

    public boolean useItemOnEntity(@NotNull Player player, @NotNull Mob mob) {
        return this.getItem().useOnEntity(this, player, mob);
    }

    @NotNull
    public ItemStack copy() {
        return new ItemStack(this.itemID, this.stackSize, this.metadata, new CompoundTag(this.tag));
    }

    public static boolean areItemStacksEqual(@Nullable ItemStack stack1, @Nullable ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.isItemStackEqual(stack2);
    }

    private boolean isItemStackEqual(@NotNull ItemStack itemstack) {
        if (this.stackSize != itemstack.stackSize) {
            return false;
        }
        if (this.itemID != itemstack.itemID) {
            return false;
        }
        return this.metadata == itemstack.metadata;
    }

    public boolean isItemEqual(@Nullable ItemStack itemstack) {
        return itemstack != null && this.itemID == itemstack.itemID && this.metadata == itemstack.metadata;
    }

    @NotNull
    public String getItemKey() {
        return this.getItem().getLanguageKey(this);
    }

    @NotNull
    public String getItemDescription() {
        return this.getItem().getTranslatedDescription(this);
    }

    @Nullable
    public static ItemStack copyItemStack(@Nullable ItemStack itemstack) {
        return itemstack != null ? itemstack.copy() : null;
    }

    @NotNull
    public String toString() {
        return this.stackSize + " * " + this.getItem().getKey() + ":" + this.metadata;
    }

    public void updateAnimation(@NotNull World world, @NotNull Entity entity, int slotId, boolean isHeld) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        this.getItem().inventoryTick(this, world, entity, slotId, isHeld);
    }

    public void onCrafting(@NotNull World world, @NotNull Player entityplayer) {
        entityplayer.addStat(this.getItem().getStat("stat_crafted"), this.stackSize);
        this.getItem().onCraftedBy(this, world, entityplayer);
    }

    public boolean isStackEqual(@NotNull ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.stackSize == itemstack.stackSize && this.metadata == itemstack.metadata;
    }

    public boolean canStackWith(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        if (this.itemID != itemStack.itemID || this.metadata != itemStack.metadata) {
            return false;
        }
        CompoundTag nbt1 = this.tag;
        CompoundTag nbt2 = itemStack.tag;
        return nbt1.equals(nbt2);
    }

    @Nullable
    public static ItemStack readItemStackFromNbt(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        ItemStack stack = new ItemStack();
        stack.readFromNBT(nbt);
        if (stack.stackSize <= 0) {
            return null;
        }
        return stack;
    }

    public boolean hasCustomName() {
        return this.tag.getBoolean("overrideName");
    }

    public boolean hasCustomColor() {
        return this.tag.getBoolean("overrideColor");
    }

    @Nullable
    public String getCustomName() {
        if (this.tag.getBoolean("overrideName")) {
            return this.tag.getString("name");
        }
        return null;
    }

    public byte getCustomColor() {
        if (this.tag.getBoolean("overrideColor")) {
            return this.tag.getByte("color");
        }
        return -1;
    }

    @NotNull
    public String getDisplayName() {
        if (this.tag.getBoolean("overrideName")) {
            return String.valueOf(TextFormatting.ITALIC) + this.tag.getString("name");
        }
        return this.getItem().getTranslatedName(this);
    }

    public byte getDisplayColor() {
        if (this.tag.getBoolean("overrideColor")) {
            return this.tag.getByte("color");
        }
        return 0;
    }

    public void setCustomName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            this.removeCustomName();
            return;
        }
        this.tag.putBoolean("overrideName", true);
        this.tag.putString("name", name);
    }

    public void setCustomColor(byte color) {
        if (color < 0) {
            this.removeCustomColor();
            return;
        }
        this.tag.putBoolean("overrideColor", true);
        this.tag.putByte("color", color);
    }

    public void removeCustomName() {
        ((Map)this.tag.getValue()).remove("overrideName");
        ((Map)this.tag.getValue()).remove("name");
    }

    public void removeCustomColor() {
        ((Map)this.tag.getValue()).remove("overrideColor");
        ((Map)this.tag.getValue()).remove("color");
    }

    @NotNull
    public CompoundTag getData() {
        return this.tag;
    }

    public void setData(@Nullable CompoundTag tag) {
        if (tag == null) {
            tag = new CompoundTag();
        }
        this.tag = tag;
    }
}

