/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.gui;

import com.mojang.logging.LogUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import org.slf4j.Logger;
import org.useless.seedviewer.data.ViewerBiome;
import org.useless.seedviewer.data.ViewerChunk;
import org.useless.seedviewer.gui.ChunkProvider;
import org.useless.seedviewer.gui.components.Viewport;

public class ChunkView {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService InitializerService = Executors.newFixedThreadPool(10);
    private static final ExecutorService PostProcessorService = Executors.newFixedThreadPool(10);
    private final BufferedImage biomeMapImage = new BufferedImage(16, 16, 2);
    private final BufferedImage terrainMapImage = new BufferedImage(16, 16, 2);
    private final BufferedImage heightMapImage = new BufferedImage(16, 16, 2);
    private final BufferedImage waterDepthMapImage = new BufferedImage(16, 16, 2);
    private final Rectangle bounds;
    private final ChunkPos location;
    private final ChunkProvider provider;
    private final Viewport viewport;
    public long lastSeenTime = System.currentTimeMillis();
    private final Future<?> loadTask;
    private Future<?> processTask = null;
    private boolean hasInitialized = false;
    private volatile boolean hasPostProcessed = false;

    public ChunkView(Viewport viewport, ChunkPos location, ChunkProvider provider) {
        this.viewport = viewport;
        this.location = location;
        this.provider = provider;
        this.bounds = new Rectangle(location.x * 16, location.z * 16, 16, 16);
        this.loadTask = InitializerService.submit(() -> {
            try {
                ViewerChunk chunk = provider.getChunk(location);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        ChunkTilePos pos2D = new ChunkTilePos(x, 0, z);
                        int h = chunk.getHeight(pos2D) - 1;
                        if (h < 0) {
                            h = 0;
                        }
                        this.heightMapImage.setRGB(x, z, h & 0xFF);
                        int wd = chunk.getWaterDepth(pos2D) & 0xFF;
                        this.waterDepthMapImage.setRGB(x, z, 0xFF000000 | wd << 16 | wd << 8 | wd);
                        ViewerBiome b = chunk.getBiome(new ChunkTilePos(x, h, z));
                        this.biomeMapImage.setRGB(x, z, b.getColor() | Integer.MIN_VALUE);
                        this.terrainMapImage.setRGB(x, z, chunk.getBlockColor(new ChunkTilePos(x, h, z)));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error when initializing chunk {}, {}", location.x, location.z, e);
            }
            finally {
                this.hasInitialized = true;
            }
        });
    }

    public boolean hasInit() {
        return this.hasInitialized;
    }

    public boolean hasProcessed() {
        return this.hasPostProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ChunkView posZ) {
        if (this.hasProcessed()) {
            return;
        }
        ChunkView chunkView = this;
        synchronized (chunkView) {
            this.processTask = PostProcessorService.submit(() -> {
                try {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int shade;
                            int depth = this.waterDepthMapImage.getRGB(x, z) & 0xFF;
                            if (depth == 0) {
                                int lastHeight = z == 0 ? posZ.getHeightMapImage().getRGB(x, z + 15) & 0xFF : this.heightMapImage.getRGB(x, z - 1) & 0xFF;
                                int height = this.heightMapImage.getRGB(x, z) & 0xFF;
                                shade = height == lastHeight ? 220 : (height < lastHeight ? 180 : 255);
                            } else {
                                double d3 = (double)depth * 0.1 + (double)(x + z & 1) * 0.2;
                                shade = d3 < 0.5 ? 255 : (d3 > 0.9 ? 180 : 220);
                            }
                            if (shade == 255) continue;
                            int current = this.terrainMapImage.getRGB(x, z);
                            int a = current >> 24 & 0xFF;
                            int r = (current >> 16 & 0xFF) * shade / 255;
                            int g = (current >> 8 & 0xFF) * shade / 255;
                            int b = (current & 0xFF) * shade / 255;
                            this.terrainMapImage.setRGB(x, z, a << 24 | r << 16 | g << 8 | b);
                        }
                    }
                }
                finally {
                    this.hasPostProcessed = true;
                    this.viewport.repaint();
                }
            });
        }
    }

    public ChunkPos getLocation() {
        return this.location;
    }

    public BufferedImage getBiomeMapImage() {
        return this.biomeMapImage;
    }

    public BufferedImage getTerrainMapImage() {
        return this.terrainMapImage;
    }

    public BufferedImage getHeightMapImage() {
        return this.heightMapImage;
    }

    public Rectangle getWorldBounds() {
        return this.bounds;
    }

    public void kill() {
        if (this.processTask != null) {
            this.processTask.cancel(true);
        }
        if (this.loadTask != null) {
            this.loadTask.cancel(true);
        }
    }
}

