/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.core.util.helper.LightIndexHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorFont {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean drawing = false;
    private int texture = -1;
    private long config;
    private boolean shadow;
    private final IntArrayList renderRanges = new IntArrayList(48);
    private final int vao;
    private final int vbo;
    @NotNull
    private final String name;
    private ByteBuffer data;
    private int start;
    private int vertexCount;

    public TessellatorFont(@NotNull String name, int initialCapacity) {
        this.name = name;
        this.data = BufferUtils.createByteBuffer(initialCapacity);
        this.vao = GL41.glGenVertexArrays();
        this.vbo = GL41.glGenBuffers();
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        int vertSize = 17;
        int offset = 0;
        GL41.glVertexAttribPointer(0, 2, 5126, false, vertSize, offset);
        GL41.glVertexAttribPointer(1, 2, 5121, false, vertSize, offset += 8);
        GL41.glVertexAttribPointer(2, 4, 5121, true, vertSize, offset += 2);
        GL41.glVertexAttribPointer(3, 2, 5121, false, vertSize, offset += 4);
        GL41.glVertexAttribPointer(4, 1, 5121, false, vertSize, offset += 2);
        ++offset;
        GL41.glVertexAttrib1f(5, LightIndexHelper.lightIndex2i(15, 15));
        GL41.glEnableVertexAttribArray(0);
        GL41.glEnableVertexAttribArray(1);
        GL41.glEnableVertexAttribArray(2);
        GL41.glEnableVertexAttribArray(3);
        GL41.glEnableVertexAttribArray(4);
        GL41.glBindVertexArray(0);
    }

    public void startDrawing() {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException(this.name + " already drawing!");
        }
        this.drawing = true;
        this.start = 0;
        this.vertexCount = 0;
        this.texture = -1;
        this.renderRanges.clear();
        this.data.clear();
        this.setConfig(0xFFFFFFFFL);
    }

    public void addChar(double x, double y, int width, int height, int u, int v) {
        this.checkIsDrawing();
        this.checkCanFit(64);
        this.data.putFloat((float)x);
        this.data.putFloat((float)y);
        this.data.put((byte)width);
        this.data.put((byte)height);
        long color = this.config & 0xFFFFFFFFL;
        byte a = (byte)((color & 0xFF000000L) >> 24);
        byte r = (byte)((color & 0xFF0000L) >> 16);
        byte g = (byte)((color & 0xFF00L) >> 8);
        byte b = (byte)(color & 0xFFL);
        if (a == 0) {
            a = -1;
        }
        this.data.put(r).put(g).put(b).put(a);
        this.data.put((byte)u);
        this.data.put((byte)v);
        byte packedConfig = (byte)(this.config >> 32 | (long)(this.shadow ? 128 : 0));
        this.data.put(packedConfig);
        ++this.vertexCount;
    }

    public void draw() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
        this.drawing = false;
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        GL41.glVertexAttrib1f(5, GLRenderer.getLightIndex());
        GL41.glBufferData(34962, this.data.flip(), 35040);
        int size = this.renderRanges.size();
        for (int i = 0; i < size; i += 3) {
            int texture = this.renderRanges.getInt(i);
            int start = this.renderRanges.getInt(i + 1);
            int count = this.renderRanges.getInt(i + 2);
            GL41.glBindTexture(3553, texture);
            GL41.glDrawArrays(DrawMode.POINTS.cap, start, count);
        }
        if (this.texture != -1) {
            GL41.glBindTexture(3553, this.texture);
            GL41.glDrawArrays(DrawMode.POINTS.cap, this.start, this.vertexCount);
        }
        GL41.glBindVertexArray(0);
    }

    @NotNull
    public FontRenderBuffer record(int vao, int vbo) {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
        this.drawing = false;
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        int vertSize = 17;
        int offset = 0;
        GL41.glVertexAttribPointer(0, 2, 5126, false, vertSize, offset);
        GL41.glVertexAttribPointer(1, 2, 5121, false, vertSize, offset += 8);
        GL41.glVertexAttribPointer(2, 4, 5121, true, vertSize, offset += 2);
        GL41.glVertexAttribPointer(3, 2, 5121, false, vertSize, offset += 4);
        GL41.glVertexAttribPointer(4, 1, 5121, false, vertSize, offset += 2);
        ++offset;
        GL41.glVertexAttrib1f(5, LightIndexHelper.lightIndex2i(15, 15));
        GL41.glEnableVertexAttribArray(0);
        GL41.glEnableVertexAttribArray(1);
        GL41.glEnableVertexAttribArray(2);
        GL41.glEnableVertexAttribArray(3);
        GL41.glEnableVertexAttribArray(4);
        GL41.glBufferData(34962, this.data.flip(), 35040);
        GL41.glBindVertexArray(0);
        boolean lastValid = this.texture != -1;
        int[] metadata = new int[this.renderRanges.size() + (lastValid ? 3 : 0)];
        int size = this.renderRanges.size();
        for (int i = 0; i < size; ++i) {
            metadata[i] = this.renderRanges.getInt(i);
        }
        if (lastValid) {
            metadata[metadata.length - 3] = this.texture;
            metadata[metadata.length - 2] = this.start;
            metadata[metadata.length - 1] = this.vertexCount;
        }
        return new FontRenderBuffer(vao, vbo, metadata);
    }

    public void setShadow(boolean shadow) {
        this.checkIsDrawing();
        this.shadow = shadow;
    }

    public void setConfig(long config) {
        this.checkIsDrawing();
        this.config = config;
    }

    public void setTexture(int texture) {
        this.checkIsDrawing();
        if (this.texture != texture && this.texture != -1) {
            this.renderRanges.add(this.texture);
            this.renderRanges.add(this.start);
            this.renderRanges.add(this.vertexCount);
            this.start += this.vertexCount;
            this.vertexCount = 0;
        }
        this.texture = texture;
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
    }

    public void checkCanFit(int size) {
        if (this.data.capacity() < this.data.position() + size) {
            int newSize = this.data.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", this.name, this.data.capacity(), newSize);
            ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.data.flip();
            newBuffer.put(this.data);
            this.data = newBuffer;
        }
    }

    public record FontRenderBuffer(int vao, int vbo, int[] metadata) {
        public void delete() {
            GL41.glDeleteVertexArrays(this.vao);
            GL41.glDeleteBuffers(this.vbo);
        }

        public void render() {
            GLRenderer.globalSetUniforms(Shaders.FONT);
            Shaders.FONT.bind();
            GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), 0.0f);
            GL41.glBindVertexArray(this.vao);
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glVertexAttrib1f(5, GLRenderer.getLightIndex());
            int size = this.metadata.length;
            for (int i = 0; i < size; i += 3) {
                int texture = this.metadata[i];
                int start = this.metadata[i + 1];
                int count = this.metadata[i + 2];
                GL41.glBindTexture(3553, texture);
                GL41.glDrawArrays(DrawMode.POINTS.cap, start, count);
            }
            GL41.glBindVertexArray(0);
        }
    }
}

