/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class FractalNoise3D<T extends Noise3D>
extends FractalNoise2D<T>
implements Noise3D {
    @NotNull
    private final Vector2d range = new Vector2d();

    public FractalNoise3D(@NotNull @NotNull T @NotNull [] octaves) {
        super(octaves);
        this.calculateRange();
    }

    private void calculateRange() {
        @NotNull Vector2dc innerRange = ((Noise3D[])this.octaves)[0].getRange3D();
        double min = 0.0;
        double max = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < ((Noise3D[])this.octaves).length; ++i) {
            min += innerRange.x() * amplitude;
            max += innerRange.y() * amplitude;
            amplitude *= this.persistence;
        }
        this.range.set(min, max);
    }

    @Override
    @NotNull
    public Vector2dc getRange3D() {
        return this.range;
    }

    @Override
    @NotNull
    public FractalNoise2D<T> setPersistence(double persistence) {
        super.setPersistence(persistence);
        this.calculateRange();
        return this;
    }

    @Override
    public double getValue(double x, double y, double z) {
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (Noise3D octave : (Noise3D[])this.octaves) {
            out += octave.getValue(x * frequency, y * frequency, z * frequency) * amplitude;
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * ySize * zSize) {
            out = new double[xSize * ySize * zSize];
        }
        double frequency = 1.0;
        for (Noise3D octave : (Noise3D[])this.octaves) {
            octave.addRegion(out, x, y, z, xSize, ySize, zSize, xScale * frequency, yScale * frequency, zScale * frequency, amplitude);
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }
}

