/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.GenericSettingNode;
import net.minecraft.core.world.settings.ValueSettingNode;
import net.minecraft.core.world.settings.ValueSettingNodeVisibilityListener;
import org.jetbrains.annotations.NotNull;

public abstract class ValueGenericSettingNode<T>
extends GenericSettingNode
implements ValueSettingNode<T> {
    @NotNull
    private final Text name;
    @NotNull
    private final @NotNull Class<@NotNull T> valueClass;
    @NotNull
    private ValueSettingNodeVisibilityListener<T> childrenVisibilityListener = ValueSettingNodeVisibilityListener::alwaysVisible;

    public ValueGenericSettingNode(@NotNull String key, @NotNull Text name, @NotNull Class<T> valueClass) {
        super(key);
        this.name = name;
        this.valueClass = valueClass;
    }

    @Override
    @NotNull
    public @NotNull Class<@NotNull T> getValueClass() {
        return this.valueClass;
    }

    @Override
    @NotNull
    public Text getName() {
        return this.name;
    }

    @NotNull
    public final ValueGenericSettingNode<T> withChildrenVisibilityListener(@NotNull ValueSettingNodeVisibilityListener<T> childrenVisibilityListener) {
        this.childrenVisibilityListener = childrenVisibilityListener;
        return this;
    }

    @Override
    public boolean areChildrenVisible(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.isVisible(dimension, config) && this.childrenVisibilityListener.isVisible(config, config.getDimensionSettings(dimension).getNodeValue(this, config));
    }
}

