/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.Tag;
import java.util.zip.DataFormatException;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;

public class BooleanSettingNode
extends ValueGenericSettingNode<Boolean> {
    @NotNull
    private static final TranslatableText ON = new TranslatableText("world_settings.values.on");
    @NotNull
    private static final TranslatableText OFF = new TranslatableText("world_settings.values.off");
    private final boolean defaultValue;

    public BooleanSettingNode(@NotNull String key, @NotNull Text name, boolean defaultValue) {
        super(key, name, Boolean.class);
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public Boolean getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.defaultValue;
    }

    @Override
    public boolean validateValue(@NotNull Boolean value, @NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return true;
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull Boolean value) {
        if (value.booleanValue()) {
            return ON;
        }
        return OFF;
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@NotNull Boolean value) {
        if (value.booleanValue()) {
            return new ByteTag(1);
        }
        return new ByteTag(0);
    }

    @Override
    @NotNull
    public Boolean deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof ByteTag) {
            @NotNull ByteTag byteTag = (ByteTag)tag;
            return (Byte)byteTag.getValue() != 0;
        }
        throw new DataFormatException("Tag was wrong type!");
    }
}

