/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.settingnode.conversion;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.worldsettings.NodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.BooleanValueNodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.ListValueNodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.NestedNodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.RangeIntegerNodeComponent;
import net.minecraft.client.gui.worldsettings.settingnode.conversion.NodeIntoComponentAdapter;
import net.minecraft.core.world.settings.ContainerSettingNode;
import net.minecraft.core.world.settings.ListValueSettingNode;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.impl.BooleanSettingNode;
import net.minecraft.core.world.settings.impl.RangeIntegerSettingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeAdapterRegistry {
    @NotNull
    private static final @NotNull Map<@NotNull Class<?>, @NotNull NodeIntoComponentAdapter<?, ?>> ADAPTERS = new Object2ObjectOpenHashMap();

    private NodeAdapterRegistry() throws IllegalAccessException {
        throw new IllegalAccessException("No NodeAdapterRegistry for you!");
    }

    public static <T extends SettingNode, C extends NodeComponent> void register(@NotNull Class<T> settingNodeClass, @NotNull NodeIntoComponentAdapter<T, C> adapter) {
        ADAPTERS.put(settingNodeClass, adapter);
    }

    @NotNull
    public static <T extends SettingNode, C extends NodeComponent> C adapt(@NotNull T settingNode, int nestLevel) {
        @NotNull Class<?> settingNodeClass = settingNode.getClass();
        @Nullable NodeIntoComponentAdapter<?, ?> adapter = ADAPTERS.get(settingNodeClass);
        if (adapter == null) {
            for (Class<?> clazz : ADAPTERS.keySet()) {
                if (!clazz.isAssignableFrom(settingNodeClass)) continue;
                return (C)Objects.requireNonNull(ADAPTERS.get(clazz)).adapt(settingNode, nestLevel);
            }
            throw new IllegalArgumentException("Node has no adapter!");
        }
        return (C)adapter.adapt(settingNode, nestLevel);
    }

    static {
        NodeAdapterRegistry.register(ContainerSettingNode.class, NestedNodeComponent::new);
        NodeAdapterRegistry.register(ListValueSettingNode.class, ListValueNodeComponent::new);
        NodeAdapterRegistry.register(BooleanSettingNode.class, BooleanValueNodeComponent::new);
        NodeAdapterRegistry.register(RangeIntegerSettingNode.class, RangeIntegerNodeComponent::new);
    }
}

