/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Toggleable;
import org.jetbrains.annotations.NotNull;

public class OptionBoolean
extends OptionToggleable<Boolean>
implements Toggleable {
    public static final Boolean[] values = new Boolean[]{false, true};

    public OptionBoolean(@NotNull String name, boolean value) {
        super(name, value, values);
    }

    public boolean isBoolean() {
        return true;
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        this.value = string.equalsIgnoreCase("true");
    }

    @Override
    public boolean isSlider() {
        return false;
    }

    public boolean isTrue() {
        return (Boolean)this.value;
    }

    @Override
    @NotNull
    public String getDisplayString() {
        I18n i18n = I18n.getInstance();
        if (this.displayStringProvider != null) {
            return this.displayStringProvider.getDisplayString(Minecraft.getMinecraft(), i18n, this);
        }
        if (((Boolean)this.value).booleanValue()) {
            return i18n.translateKey("options.on");
        }
        return i18n.translateKey("options.off");
    }
}

