/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.OptionToggleable;
import org.jetbrains.annotations.NotNull;

public class OptionRange
extends OptionToggleable<Integer> {
    public final int highest;
    public final int lowest;

    public OptionRange(@NotNull String name, int defaultValue, int values2) {
        super(name, defaultValue, OptionRange.getValueArray(values2));
        this.highest = ((Integer[])this.values)[((Integer[])this.values).length - 1];
        this.lowest = ((Integer[])this.values)[0];
    }

    public OptionRange(@NotNull String name, int defaultValue, int lowest, int highest) {
        super(name, defaultValue, OptionRange.getValueArray(lowest, highest));
        this.highest = highest;
        this.lowest = lowest;
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        this.value = Integer.parseInt(string);
    }

    public static Integer[] getValueArray(int size) {
        Integer[] array = new Integer[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static Integer[] getValueArray(int lowest, int highest) {
        Integer[] array = new Integer[highest - lowest + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i + lowest;
        }
        return array;
    }

    @Override
    public boolean isSlider() {
        return true;
    }
}

