/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldTypeFX {
    @NotNull
    public final WorldType worldType;
    private boolean hasClouds = true;
    private boolean hasSky = true;
    private boolean hasGround = true;
    private boolean hasAurora = false;
    @Nullable
    private Float cloudHeight = null;

    public WorldTypeFX(@NotNull WorldType worldType) {
        this.worldType = worldType;
    }

    @NotNull
    public WorldTypeFX setHasClouds(boolean flag) {
        this.hasClouds = flag;
        return this;
    }

    @NotNull
    public WorldTypeFX setHasSky(boolean flag) {
        this.hasSky = flag;
        return this;
    }

    @NotNull
    public WorldTypeFX setHasGround(boolean flag) {
        this.hasGround = flag;
        return this;
    }

    @NotNull
    public WorldTypeFX setHasAurora(boolean flag) {
        this.hasAurora = flag;
        return this;
    }

    @NotNull
    public WorldTypeFX setCloudHeight(float cloudHeight) {
        this.cloudHeight = Float.valueOf(cloudHeight);
        return this;
    }

    public boolean hasClouds() {
        return this.hasClouds;
    }

    public boolean hasSky() {
        return this.hasSky;
    }

    public float getCloudHeight(@NotNull World world) {
        if (this.cloudHeight == null) {
            return this.worldType.getMaxY(world) + 1 - 20;
        }
        return this.cloudHeight.floatValue();
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public boolean hasAurora() {
        return this.hasAurora;
    }

    @NotNull
    public Vector3fc getFogColor(@NotNull World world, double x, double y, double z, float celestialAngle, float partialTick) {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public float @Nullable [] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    public void playerAnimationTick(@NotNull World world, @NotNull Player player) {
    }
}

