/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.NotNull;

public class MenuContainer
extends MenuAbstract {
    private Container container;
    private int numberOfRows;

    public MenuContainer(Container playerContainer, Container container) {
        int x;
        int y;
        this.container = container;
        this.numberOfRows = container.getContainerSize() / 9;
        int playerInventoryYOffset = (this.numberOfRows - 4) * 18;
        for (y = 0; y < this.numberOfRows; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot(container, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot(playerContainer, x + y * 9 + 9, 8 + x * 18, 103 + y * 18 + playerInventoryYOffset));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(playerContainer, i, 8 + i * 18, 161 + playerInventoryYOffset));
        }
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    @Override
    public IntList getMoveSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        int chestSize = this.numberOfRows * 9;
        if (slot.index >= 0 && slot.index < chestSize) {
            return this.getSlots(0, chestSize, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index >= chestSize && slot.index < chestSize + 27) {
                return this.getSlots(chestSize, 27, false);
            }
            if (slot.index >= chestSize + 27 && slot.index < chestSize + 36) {
                return this.getSlots(chestSize + 27, 9, false);
            }
        } else if (slot.index >= chestSize && slot.index < chestSize + 36) {
            return this.getSlots(chestSize, 36, false);
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        int chestSize = this.numberOfRows * 9;
        if (slot.index < chestSize) {
            return this.getSlots(chestSize, 36, true);
        }
        return this.getSlots(0, chestSize, false);
    }
}

