/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Nullability {
    @NotNull
    public static <T> T unwrapOr(@Nullable T value, @NotNull T or) {
        if (value == null) {
            return or;
        }
        return value;
    }

    @NotNull
    public static <T> T unwrapOrElse(@Nullable T value, @NotNull @NotNull Supplier<@NotNull T> or) {
        if (value == null) {
            return or.get();
        }
        return value;
    }

    @Nullable
    public static <T, E> E map(@Nullable T value, @NotNull @NotNull Function<@NotNull T, @NotNull E> map) {
        if (value != null) {
            return map.apply(value);
        }
        return null;
    }

    @NotNull
    public static <T, E> E mapOr(@Nullable T value, @NotNull E or, @NotNull @NotNull Function<@NotNull T, @NotNull E> map) {
        if (value != null) {
            return map.apply(value);
        }
        return or;
    }
}

