/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import org.jetbrains.annotations.NotNull;

public abstract class LargeFeature {
    public final void generate(@NotNull World world, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result) {
        int radius = this.getRadiusChunk();
        Random rand = new Random(world.getRandomSeed());
        long randX = rand.nextLong() / 2L * 2L + 1L;
        long randZ = rand.nextLong() / 2L * 2L + 1L;
        for (int chunkX = baseChunkX - radius; chunkX <= baseChunkX + radius; ++chunkX) {
            for (int chunkZ = baseChunkZ - radius; chunkZ <= baseChunkZ + radius; ++chunkZ) {
                rand.setSeed((long)chunkX * randX + (long)chunkZ * randZ ^ world.getRandomSeed());
                this.doGeneration(world, rand, chunkX, chunkZ, baseChunkX, baseChunkZ, result);
            }
        }
    }

    protected abstract void doGeneration(@NotNull World var1, @NotNull Random var2, int var3, int var4, int var5, int var6, @NotNull ChunkGeneratorResult var7);

    public int getRadiusChunk() {
        return 8;
    }
}

