#version 410 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aSize;
layout (location = 2) in vec4 aColor;
layout (location = 3) in vec2 aUV;
layout (location = 4) in float aConfig;
layout (location = 5) in float aLightmap;

out VS_OUT {
    vec2 size;
    vec4 color;
    vec2 uv;
    vec2 lightmap;
    float config;
} vs_out;

uniform float uZ;

vec2 unpackLightCoord() {
    int asInt = int(aLightmap);
    return vec2(((asInt & 0xF) + 0.5)/16.0, (((asInt & 0xF0) >> 4) + 0.5)/16.0);
}

void main() {
    gl_Position = vec4(aPos, uZ, 1);

    vs_out.size = aSize/2;
    vs_out.color = aColor;
    vs_out.uv = aUV/256.0;
    vs_out.lightmap = unpackLightCoord();
    vs_out.config = aConfig;
}
