/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityJukebox;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicJukebox
extends BlockLogic {
    public BlockLogicJukebox(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
        block.withEntity(TileEntityJukebox::new);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (world.getBlockData(tilePos) == 0) {
            return false;
        }
        this.ejectRecord(world, tilePos);
        return true;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        if (world.getBlockData(tilePos) != 0) {
            this.ejectRecord(world, tilePos);
        }
    }

    public void playRecord(@NotNull World world, @NotNull TilePos tilePos, int recordId) {
        TileEntity tileEntity;
        if (!world.isClientSide && (tileEntity = world.getTileEntity(tilePos)) instanceof TileEntityJukebox) {
            TileEntityJukebox jukebox = (TileEntityJukebox)tileEntity;
            jukebox.record = recordId;
            jukebox.setChanged();
            world.setBlockDataNotify(tilePos, 1);
        }
    }

    public void ejectRecord(@NotNull World world, @NotNull TilePosc tilePos) {
        if (world.isClientSide) {
            return;
        }
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity != null) {
            tileEntity.dropContents(world, tilePos.x(), tilePos.y(), tilePos.z());
        }
    }
}

