/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockLadder<T extends BlockLogicLadder>
extends ItemBlock<T> {
    public ItemBlockLadder(@NotNull Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        Side sideForPlacement;
        TilePos bp = new TilePos(blockPos);
        Block<?> clickedBlock = world.getBlockType(bp);
        BlockLogicLadder ladder = (BlockLogicLadder)this.block.getLogic();
        if (clickedBlock == this.block && player != null && !player.isSneaking()) {
            Side clickedLadderSide = ladder.getSideFromMeta(world.getBlockData(bp));
            while (world.getBlockType(bp) == this.block && ladder.getSideFromMeta(world.getBlockData(bp)) == clickedLadderSide) {
                --bp.y;
            }
            int meta = ladder.getMetaForSide(clickedLadderSide);
            if (ladder.canExistAt(world, new TilePos(bp), meta)) {
                return this.placeBlock(selfStack, world, bp, meta, player, clickedLadderSide, 0.5, 0.5);
            }
            return false;
        }
        if (!world.canPlaceInsideBlock(bp)) {
            bp = bp.add(side.getDirection(), new TilePos());
        }
        if ((sideForPlacement = ladder.getSideForPlacement(world, bp, side)) == null) {
            return false;
        }
        int meta = ladder.getMetaForSide(sideForPlacement);
        if (ladder.canExistAt(world, bp, meta)) {
            return this.placeBlock(selfStack, world, bp, meta, player, sideForPlacement, xHit, yHit);
        }
        return false;
    }

    public boolean placeBlock(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TilePos tilePos, int meta, @Nullable Player player, @NotNull Side side, double xHit, double yHit) {
        if (world.canPlaceInsideBlock(tilePos) && world.canBlockIdBePlacedAt(this.block.id(), tilePos, false, side) && selfStack.consumeItem(player) && world.setBlockTypeDataNotify(tilePos, this.block, meta)) {
            if (player == null) {
                this.block.onPlacedOnSide(world, tilePos, side, xHit, yHit);
            } else {
                this.block.onPlacedByMob(world, tilePos, side, player, xHit, yHit);
            }
            world.playBlockSoundEffect(player, (float)tilePos.x + 0.5f, (float)tilePos.y + 0.5f, (float)tilePos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }
}

