/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.Tag;
import java.util.zip.DataFormatException;
import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.RangeValueSettingNode;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;

public class RangeIntegerSettingNode
extends ValueGenericSettingNode<Integer>
implements RangeValueSettingNode<Integer> {
    private final int minValue;
    private final int maxValue;
    private final int defaultValue;

    public RangeIntegerSettingNode(@NotNull String key, @NotNull Text name, int minValue, int maxValue, int defaultValue) {
        super(key, name, Integer.class);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public Integer getMinimumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.minValue;
    }

    @Override
    @NotNull
    public Integer getMaximumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.maxValue;
    }

    @Override
    @NotNull
    public Integer getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.defaultValue;
    }

    @Override
    public boolean validateValue(@NotNull Integer value, @NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return value >= this.getMinimumValue(dimension, config) && value <= this.getMaximumValue(dimension, config);
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull Integer value) {
        return new LiteralText("" + value);
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@NotNull Integer value) {
        return new IntTag(value);
    }

    @Override
    @NotNull
    public Integer deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof IntTag) {
            @NotNull IntTag intTag = (IntTag)tag;
            return (Integer)intTag.getValue();
        }
        throw new DataFormatException("Tag was wrong type!");
    }
}

