/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericButton<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel idle;
    @NotNull
    public final StaticBlockModel active;

    public BlockModelGenericButton(@NotNull Block<T> block, @NotNull String basekey) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/inventory"));
        this.idle = BlockModelDispatcher.loadDataModel(basekey + "/idle").asModel();
        this.active = BlockModelDispatcher.loadDataModel(basekey + "/active").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int direction = worldSource.getBlockData(tilePos) & 7;
        return switch (direction) {
            case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 1, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
            case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 3, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
            case 3 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 0, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
            case 4 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 2, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
            case 5 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 2, 0, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
            default -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, true, cullFaces, overrideTexture);
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        boolean pressed = (source.getBlockData(tilePosc) & 8) != 0;
        return pressed ? this.active : this.idle;
    }
}

