/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicSponge
extends BlockLogic {
    final boolean isWet;

    public BlockLogicSponge(@NotNull Block<?> block, boolean isWet) {
        super(block, Materials.SPONGE);
        this.isWet = isWet;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        super.onPlacedByWorld(world, tilePos);
        if ((world.dimension == Dimension.NETHER || this.inHot(world, tilePos)) && this.isWet) {
            world.setBlockTypeNotify(tilePos, Blocks.SPONGE_DRY);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)tilePos.x() + Math.random(), (double)tilePos.y() + Math.random(), (double)tilePos.z() + Math.random(), 0.0, 0.0, 0.0, 0);
            }
        }
        int radius = 2;
        if (!this.isWet && this.inWater(world, tilePos)) {
            TilePos queryPos = new TilePos();
            queryPos.x = tilePos.x() - 2;
            while (queryPos.x <= tilePos.x() + 2) {
                queryPos.y = tilePos.y() - 2;
                while (queryPos.y <= tilePos.y() + 2) {
                    queryPos.z = tilePos.z() - 2;
                    while (queryPos.z <= tilePos.z() + 2) {
                        if (world.getBlockType(queryPos).hasTag(BlockTags.IS_WATER)) {
                            world.setBlockTypeNotify(queryPos, Blocks.AIR);
                        }
                        ++queryPos.z;
                    }
                    ++queryPos.y;
                }
                ++queryPos.x;
            }
            world.setBlockTypeNotify(tilePos, Blocks.SPONGE_WET);
        }
    }

    public boolean inWater(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            Block<?> b = world.getBlockType(tilePos.add(dir, queryPos));
            if (!Blocks.hasTag(b, BlockTags.IS_WATER)) continue;
            return true;
        }
        return false;
    }

    public boolean inHot(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            Block<?> b = world.getBlockType(tilePos.add(dir, queryPos));
            if (b != Blocks.COBBLE_NETHERRACK_IGNEOUS && !Blocks.hasTag(b, BlockTags.IS_LAVA)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (!this.isWet) {
            int radius = 2;
            TilePos queryPos = new TilePos(tilePos);
            queryPos.x = tilePos.x() - radius;
            while (queryPos.x <= tilePos.x() + radius) {
                queryPos.y = tilePos.y() - radius;
                while (queryPos.y <= tilePos.y() + radius) {
                    queryPos.z = tilePos.z() - radius;
                    while (queryPos.z <= tilePos.z() + radius) {
                        world.notifyBlocksOfNeighborChange(queryPos, world.getBlockType(queryPos));
                        ++queryPos.z;
                    }
                    ++queryPos.y;
                }
                ++queryPos.x;
            }
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (this.isWet) {
            Side side = Side.sides[rand.nextInt(6)];
            if (side == Side.TOP || world.isBlockOpaqueCube(tilePos.add(side.getDirection(), new TilePos()))) {
                return;
            }
            float off1 = rand.nextFloat() * 0.9f + 0.05f;
            float off2 = rand.nextFloat() * 0.9f + 0.05f;
            float lOff = 0.01f;
            switch (side) {
                case BOTTOM: {
                    world.spawnParticle("dripWater", (float)tilePos.x() + off1, (float)tilePos.y() - lOff, (float)tilePos.z() + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case NORTH: {
                    world.spawnParticle("dripWater", (float)tilePos.x() + off1, (float)tilePos.y() + off2, (float)tilePos.z() - lOff, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case SOUTH: {
                    world.spawnParticle("dripWater", (float)tilePos.x() + off1, (float)tilePos.y() + off2, (float)(tilePos.z() + 1) + lOff, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case WEST: {
                    world.spawnParticle("dripWater", (float)tilePos.x() - lOff, (float)tilePos.y() + off1, (float)tilePos.z() + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case EAST: {
                    world.spawnParticle("dripWater", (float)(tilePos.x() + 1) + lOff, (float)tilePos.y() + off1, (float)tilePos.z() + off2, 0.0, 0.0, 0.0, 0);
                }
            }
        }
    }
}

