/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.meta;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.client.render.texture.meta.AnimationProperties;

public class AnimationPropertiesAdapter
implements JsonDeserializer<AnimationProperties>,
JsonSerializer<AnimationProperties> {
    @Override
    public AnimationProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        boolean interpolate = false;
        boolean random = false;
        int width = 1;
        int height = 1;
        int frametime = 1;
        ArrayList<AnimationProperties.Frame> frames = null;
        if (obj.has("interpolate")) {
            interpolate = obj.get("interpolate").getAsBoolean();
        }
        if (obj.has("random")) {
            random = obj.get("random").getAsBoolean();
        }
        if (obj.has("width")) {
            width = obj.get("width").getAsInt();
        }
        if (obj.has("height")) {
            height = obj.get("height").getAsInt();
        }
        if (obj.has("frametime")) {
            frametime = obj.get("frametime").getAsInt();
        }
        if (obj.has("frames")) {
            JsonArray array = obj.getAsJsonArray("frames");
            frames = new ArrayList<AnimationProperties.Frame>();
            for (JsonElement e : array) {
                if (e.isJsonPrimitive()) {
                    frames.add(new AnimationProperties.Frame(e.getAsInt(), frametime));
                    continue;
                }
                JsonObject frameObject = e.getAsJsonObject();
                int index = frameObject.get("index").getAsInt();
                int time = frametime;
                if (frameObject.has("time")) {
                    time = frameObject.get("time").getAsInt();
                }
                frames.add(new AnimationProperties.Frame(index, time));
            }
        }
        return new AnimationProperties(interpolate, random, width, height, frametime, frames);
    }

    @Override
    public JsonElement serialize(AnimationProperties src, Type typeOfSrc, JsonSerializationContext context) {
        return null;
    }
}

