/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericFenceGate<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public StaticBlockModel open;

    public BlockModelGenericFenceGate(@NotNull Block<T> block, @NotNull String baseKey) {
        super(block, BlockModelDispatcher.loadDataModel(baseKey + "_closed"));
        this.open = BlockModelDispatcher.loadDataModel(baseKey + "_open").asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int data = worldSource.getBlockData(tilePos);
        int rotation = data & 3;
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, -rotation, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        boolean open = (data & 4) != 0;
        return open ? this.open : this.staticModel;
    }
}

