/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLogicFurnaceBlast
extends BlockLogicRotatable {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final boolean isActive;
    public static boolean keepFurnaceInventory = false;

    public BlockLogicFurnaceBlast(Block<?> block, boolean active) {
        super(block, Materials.METAL);
        this.isActive = active;
        block.withEntity(TileEntityFurnaceBlast::new);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Blocks.FURNACE_BLAST_IDLE);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isActive) {
            return;
        }
        double posX = (double)tilePos.x() + 0.5;
        double posY = (double)tilePos.y() + (double)(rand.nextFloat() * 6.0f) / 16.0;
        double posZ = (double)tilePos.z() + 0.5;
        double f3 = 0.52;
        float f4 = rand.nextFloat() * 0.6f - 0.3f;
        switch (BlockLogicRotatable.getDirectionFromMeta(world.getBlockData(tilePos))) {
            case WEST: {
                world.spawnParticle("smoke", posX - f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("largeSmoke", posX - f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case EAST: {
                world.spawnParticle("smoke", posX + f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("largeSmoke", posX + f3, posY, posZ + (double)f4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case NORTH: {
                world.spawnParticle("smoke", posX + (double)f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("largeSmoke", posX + (double)f4, posY, posZ - f3, 0.0, 0.0, 0.0, 0);
                break;
            }
            case SOUTH: {
                world.spawnParticle("smoke", posX + (double)f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("largeSmoke", posX + (double)f4, posY, posZ + f3, 0.0, 0.0, 0.0, 0);
            }
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntity tileEntity;
        if (!world.isClientSide && (tileEntity = world.getTileEntity(tilePos)) instanceof TileEntityFurnaceBlast) {
            TileEntityFurnaceBlast furnaceBlast = (TileEntityFurnaceBlast)tileEntity;
            player.displayBlastFurnaceScreen(furnaceBlast);
        }
        return true;
    }

    public static void updateFurnaceBlockState(@NotNull World world, @NotNull TilePos tilePos, boolean lit) {
        int meta = world.getBlockData(tilePos);
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity == null) {
            String msg = "Blast Furnace is missing Tile Entity at " + String.valueOf(tilePos) + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
            LOGGER.warn(msg);
            return;
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockTypeNotify(tilePos, Blocks.FURNACE_BLAST_ACTIVE);
        } else {
            world.setBlockTypeNotify(tilePos, Blocks.FURNACE_BLAST_IDLE);
        }
        keepFurnaceInventory = false;
        world.setBlockDataNotify(tilePos, meta);
        tileEntity.validate();
        world.setTileEntity(tilePos, tileEntity);
    }
}

