/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.util.collection.Pair;

public class WeightedRandomBagJsonAdapter
implements JsonDeserializer<WeightedRandomBag<WeightedRandomLootObject>>,
JsonSerializer<WeightedRandomBag<WeightedRandomLootObject>> {
    @Override
    public WeightedRandomBag<WeightedRandomLootObject> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray array = (JsonArray)json;
        ArrayList<Pair<WeightedRandomLootObject, Double>> entries = new ArrayList<Pair<WeightedRandomLootObject, Double>>();
        for (JsonElement jsonElement : array) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            WeightedRandomLootObject loot = (WeightedRandomLootObject)context.deserialize(jsonObject.get("loot").getAsJsonObject(), (Type)((Object)WeightedRandomLootObject.class));
            double weight = jsonObject.get("weight").getAsDouble();
            entries.add(Pair.of(loot, weight));
        }
        WeightedRandomBag<WeightedRandomLootObject> bag = new WeightedRandomBag<WeightedRandomLootObject>();
        for (Pair pair : entries) {
            bag.addEntry((WeightedRandomLootObject)pair.getLeft(), (Double)pair.getRight());
        }
        return bag;
    }

    @Override
    public JsonElement serialize(WeightedRandomBag<WeightedRandomLootObject> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray array = new JsonArray();
        List<WeightedRandomBag.Entry> entries = src.getEntriesWithWeights();
        for (WeightedRandomBag.Entry entry : entries) {
            JsonObject obj = new JsonObject();
            obj.addProperty("weight", entry.getWeight());
            obj.add("loot", context.serialize(entry.getObject()));
            array.add(obj);
        }
        return array;
    }
}

