/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.window.GameWindowGLFW;
import org.jetbrains.annotations.Nullable;

public class FramerateOptionComponent
extends ToggleableOptionComponent<Integer> {
    public FramerateOptionComponent(OptionRange option) {
        this(option, (String)null);
    }

    public FramerateOptionComponent(OptionRange option, @Nullable String tooltipTranslationKey) {
        super(option, tooltipTranslationKey);
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() && FramerateOptionComponent.mc.gameWindow instanceof GameWindowGLFW) {
            this.slider.sliderValue = FramerateOptionComponent.mc.gameWindow.getFrequency();
            this.onChanged();
            this.slider.enabled = false;
        } else {
            this.slider.sliderValue = (Integer)this.option.value;
            this.onChanged();
            this.slider.enabled = true;
        }
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            FramerateOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void init(Minecraft mc) {
        this.slider.sliderValue = this.option.getValueIndex();
        if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() && mc.gameWindow instanceof GameWindowGLFW) {
            this.slider.sliderValue = mc.gameWindow.getFrequency();
            this.slider.enabled = false;
        }
        this.onChanged();
    }
}

