/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.SF;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderIntegerBase {
    @NotNull
    protected FontRenderer fontRenderer;
    @NotNull
    protected CharSequence chars;
    @NotNull
    protected Font font;
    protected int x;
    protected int y;
    protected double z;
    protected double @Nullable [] xPosBuffer;
    protected double @Nullable [] yPosBuffer;
    protected long @Nullable [] configBuffer;
    protected long config;
    protected boolean shadow;
    protected boolean needCall;

    RenderIntegerBase() {
    }

    @NotNull
    public RenderIntegerBase init(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        if (this.needCall) {
            this.needCall = false;
            throw new IllegalStateException("Init called before prior draw call!");
        }
        this.fontRenderer = fontRenderer;
        this.font = this.fontRenderer.getFont();
        this.chars = chars;
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.xPosBuffer = xPosBuffer;
        this.yPosBuffer = yPosBuffer;
        this.configBuffer = configBuffer;
        this.config = 0xFFFFFFFFL;
        this.shadow = false;
        this.needCall = true;
        return this;
    }

    @NotNull
    public RenderIntegerBase setConfig(long config) {
        this.config = config;
        return this;
    }

    @NotNull
    public RenderIntegerBase resetConfig() {
        this.config = 0xFFFFFFFFL;
        this.shadow = false;
        this.z = 0.0;
        return this;
    }

    @NotNull
    public RenderIntegerBase setZ(double zLevel) {
        this.z = zLevel;
        return this;
    }

    @NotNull
    public RenderIntegerBase setColor(@NotNull Color color) {
        this.config = SF.setColor(this.config, color.value);
        return this;
    }

    @NotNull
    public RenderIntegerBase setColor(int argb) {
        this.config = SF.setColor(this.config, argb);
        return this;
    }

    @NotNull
    public RenderIntegerBase setFont(@NotNull Font font) {
        this.font = font;
        return this;
    }

    @NotNull
    public RenderIntegerBase setItalic() {
        this.config = SF.setItalic(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerBase setUnderline() {
        this.config = SF.setUnderline(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerBase setStrikethrough() {
        this.config = SF.setStrikethrough(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerBase setBold() {
        this.config = SF.setBold(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerBase setObfuscated() {
        this.config = SF.setObfuscated(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerBase setShadow() {
        this.shadow = true;
        return this;
    }

    public abstract void call();
}

