/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievements.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AchievementPage {
    private final Map<Achievement, AchievementEntry> entryMap = new HashMap<Achievement, AchievementEntry>();
    private final List<AchievementEntry> achievementList = new ArrayList<AchievementEntry>();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    public void addAchievement(@NotNull Achievement achievement, int x, int y) {
        AchievementEntry entry = new AchievementEntry(Objects.requireNonNull(achievement), x, y);
        this.achievementList.add(entry);
        this.entryMap.put(achievement, entry);
    }

    @NotNull
    public abstract AchievementEntry onOpenAchievement();

    @Nullable
    public abstract IconCoordinate getBackgroundTile(ScreenAchievements var1, int var2, Random var3, int var4, int var5);

    public abstract void postProcessBackground(ScreenAchievements var1, Random var2, ScreenAchievements.BGLayer var3, int var4, int var5);

    @NotNull
    public abstract ItemStack getIcon();

    @NotNull
    public List<AchievementEntry> getAchievementEntries() {
        return this.achievementList;
    }

    @Nullable
    public AchievementEntry getEntry(Achievement achievement) {
        return this.entryMap.get(achievement);
    }

    public double getCompletionFraction(StatsCounter counter) {
        int completed = 0;
        for (AchievementEntry a : this.achievementList) {
            if (!counter.isUnlocked(a.achievement)) continue;
            ++completed;
        }
        return (double)completed / (double)this.achievementList.size();
    }

    public abstract int backgroundLayers();

    public abstract int backgroundColor();

    public boolean hasAchievement(Achievement achievement) {
        return this.entryMap.containsKey(achievement);
    }

    public abstract IconCoordinate getAchievementIcon(Achievement var1);

    public abstract int lineColorLocked(boolean var1);

    public abstract int lineColorUnlocked(boolean var1);

    public abstract int lineColorCanUnlock(boolean var1);

    public static IconCoordinate getTextureFromBlock(Block<?> block) {
        return ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getOverlayTexture(0);
    }

    public static class AchievementEntry {
        public final int x;
        public final int y;
        @NotNull
        public final Achievement achievement;

        public AchievementEntry(@NotNull Achievement achievement, int x, int y) {
            this.achievement = achievement;
            this.x = x;
            this.y = y;
        }
    }
}

