/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;

public class SwitchComponent
extends InteractivePopupComponent<Boolean> {
    @NotNull
    private final Minecraft minecraft = Minecraft.getMinecraft();
    public final SwitchElement switchElement;

    public SwitchComponent(int width, boolean defaultState, String onText, String offText) {
        super(width);
        this.switchElement = new SwitchElement(0, 0, 0, width, this.getHeight(), defaultState, onText, offText);
    }

    @Override
    @NotNull
    public Boolean getOutput() {
        return this.switchElement.isOn();
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        this.switchElement.xPosition = x;
        this.switchElement.yPosition = y;
        this.switchElement.drawButton(this.minecraft, mouseX, mouseY);
    }

    @Override
    public void onClick(int x, int y, int button) {
        if (button == 0 && this.switchElement.mouseClicked(this.minecraft, x, y)) {
            this.switchElement.setOn(!this.switchElement.isOn());
            this.minecraft.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }
}

