/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public abstract class CameraUtil {
    @Nullable
    public static HitResult traceRay(@NotNull ICamera camera, @NotNull World world, double distance, float partialTick) {
        Vector3dc pos = camera.getPosition(partialTick);
        Vector3dc viewDir = camera.getViewVector(partialTick);
        Vector3d endPos = pos.add(viewDir.x() * distance, viewDir.y() * distance, viewDir.z() * distance, new Vector3d());
        return world.checkBlockCollisionBetweenPoints(pos, endPos);
    }

    public static boolean isUnderLiquid(@NotNull ICamera camera, @NotNull World world, @NotNull Material material, float partialTick) {
        double cameraY = camera.getY(partialTick);
        TilePos tilePos = camera.getTilePos(partialTick);
        @NotNull Block<?> block = world.getBlockType(tilePos);
        if (block.getMaterial() == material) {
            float fluidHeight = BlockLogicFluid.getHeight(world.getBlockData(tilePos)) - 0.2f;
            float waterSurface = (float)(tilePos.y + 1) - fluidHeight;
            return cameraY < (double)waterSurface;
        }
        return false;
    }
}

