/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileEgg;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemEgg
extends Item
implements IDispensable {
    public ItemEgg(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 16;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        selfStack.consumeItem(player);
        world.playSoundAtEntity(player, player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new ProjectileEgg(world, player));
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        ProjectileEgg projectileEgg = new ProjectileEgg(world, (double)blockPos.x() + offX, (double)blockPos.y() + offY, (double)blockPos.z() + offZ);
        projectileEgg.setHeading((double)direction.getOffsetX() * 0.6, direction.getOffsetY() == 0 ? 0.1 : (double)direction.getOffsetY() * 0.6, (float)direction.getOffsetZ() * 0.6f, 1.1f, 6.0f);
        world.entityJoinedWorld(projectileEgg);
        --selfStack.stackSize;
    }

    @Override
    public void onDispensed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Random random, @NotNull Direction direction, double x, double y, double z) {
        ProjectileEgg projectileEgg = new ProjectileEgg(world, x, y, z);
        projectileEgg.setHeading(direction.getOffsetX(), (double)direction.getOffsetY() + 0.1, direction.getOffsetZ(), 1.1f, 6.0f);
        world.entityJoinedWorld(projectileEgg);
    }
}

