/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntitySummon;
import net.minecraft.core.net.command.arguments.ArgumentTypeVector3d;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.DoubleCoordinates;
import net.minecraft.core.net.command.util.CommandHelper;
import org.joml.Vector3dc;

public class CommandSummon
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("summon").requires(CommandSource::hasAdmin)).then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("entity", ArgumentTypeEntitySummon.entity()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Vector3dc coordinates = source.getCoordinates(false);
            if (source.getSender() == null || coordinates == null) {
                throw CommandExceptions.notInWorld().create();
            }
            Entity entity = CommandSummon.summonEntityAt(c, coordinates.x(), coordinates.y() - (double)source.getSender().heightOffset, coordinates.z(), 0.0f, 0.0f);
            source.sendTranslatableMessage("command.commands.summon.success_single_entity", CommandHelper.getEntityName(entity));
            return 1;
        })).then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("position", ArgumentTypeVector3d.vec3d()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            Entity entity = CommandSummon.summonEntityAt(c, coordinates.getX(source), coordinates.getY(source, true), coordinates.getZ(source), 0.0f, 0.0f);
            source.sendTranslatableMessage("command.commands.summon.success_single_entity", CommandHelper.getEntityName(entity));
            return 1;
        })).then(ArgumentBuilderRequired.argument("amount", ArgumentTypeInteger.integer(1, 255)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            int amount = c.getArgument("amount", Integer.class);
            for (int i = 0; i < amount; ++i) {
                CommandSummon.summonEntityAt(c, coordinates.getX(source), coordinates.getY(source, true), coordinates.getZ(source), 0.0f, 0.0f);
            }
            source.sendTranslatableMessage("command.commands.summon.success_multiple_entities", amount);
            return 1;
        })))));
    }

    private static Entity summonEntityAt(CommandContext<CommandSource> c, double x, double y, double z, float yaw, float pitch) {
        Class entityClass = c.getArgument("entity", Class.class);
        Object entity = EntityDispatcher.getInstance().createEntityInWorld(entityClass, c.getSource().getWorld());
        if (entity == null) {
            throw new RuntimeException("Could not create entity for '" + String.valueOf(entityClass) + "'");
        }
        ((Entity)entity).moveTo(x, y, z, yaw, pitch);
        ((Entity)entity).spawnInit();
        c.getSource().getWorld().entityJoinedWorld((Entity)entity);
        return entity;
    }
}

