/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.gamemode;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import org.jetbrains.annotations.NotNull;

public final class Gamemode {
    @NotNull
    private final String languageKey;
    @NotNull
    private final @NotNull Function<@NotNull ContainerInventory, @NotNull MenuInventory> inventoryMenuSupplier;
    private final boolean invulnerablePlayer;
    private final boolean playerFlight;
    private final boolean blockConsumption;
    private final boolean blockBreakingAnimation;
    private final boolean toolDurability;
    private final boolean itemDrops;
    private final boolean hostileMobs;
    private final boolean fireImmunity;
    private final boolean instantPortalTravel;
    private final boolean properToolNeededToMine;
    private final boolean canInteract;
    private final boolean permaDeath;
    private final float blockReachDistance;
    private final float entityReachDistance;

    Gamemode(@NotNull String languageKey, @NotNull @NotNull Function<@NotNull ContainerInventory, @NotNull MenuInventory> inventoryMenuSupplier, boolean invulnerablePlayer, boolean playerFlight, boolean blockConsumption, boolean blockBreakingAnimation, boolean toolDurability, boolean itemDrops, boolean hostileMobs, boolean fireImmunity, boolean instantPortalTravel, boolean properToolNeededToMine, boolean canInteract, boolean permaDeath, float blockReachDistance, float entityReachDistance) {
        this.languageKey = languageKey;
        this.inventoryMenuSupplier = inventoryMenuSupplier;
        this.invulnerablePlayer = invulnerablePlayer;
        this.playerFlight = playerFlight;
        this.blockConsumption = blockConsumption;
        this.blockBreakingAnimation = blockBreakingAnimation;
        this.toolDurability = toolDurability;
        this.itemDrops = itemDrops;
        this.hostileMobs = hostileMobs;
        this.fireImmunity = fireImmunity;
        this.instantPortalTravel = instantPortalTravel;
        this.properToolNeededToMine = properToolNeededToMine;
        this.canInteract = canInteract;
        this.permaDeath = permaDeath;
        this.blockReachDistance = blockReachDistance;
        this.entityReachDistance = entityReachDistance;
    }

    @NotNull
    public String getId() {
        return Objects.requireNonNull(Registries.GAMEMODES.getKey(this));
    }

    @NotNull
    public String getLanguageKey() {
        return this.languageKey;
    }

    @NotNull
    public MenuInventory getInventoryMenu(@NotNull ContainerInventory inventory) {
        return this.inventoryMenuSupplier.apply(inventory);
    }

    public boolean hasInvulnerablePlayer() {
        return this.invulnerablePlayer;
    }

    public boolean hasPlayerFlight() {
        return this.playerFlight;
    }

    public boolean hasBlockConsumption() {
        return this.blockConsumption;
    }

    public boolean hasBlockBreakingAnimation() {
        return this.blockBreakingAnimation;
    }

    public boolean hasToolDurability() {
        return this.toolDurability;
    }

    public boolean hasItemDrops() {
        return this.itemDrops;
    }

    public boolean hasHostileMobs() {
        return this.hostileMobs;
    }

    public boolean hasFireImmunity() {
        return this.fireImmunity;
    }

    public boolean hasInstantPortalTravel() {
        return this.instantPortalTravel;
    }

    public float getBlockReachDistance() {
        return this.blockReachDistance;
    }

    public float getEntityReachDistance() {
        return this.entityReachDistance;
    }

    public boolean isProperToolNeededToMine() {
        return this.properToolNeededToMine;
    }

    public boolean canInteract() {
        return this.canInteract;
    }

    public boolean hasPermaDeath() {
        return this.permaDeath;
    }
}

