/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherConfig;
import org.jetbrains.annotations.NotNull;

public class WeatherRain
extends Weather
implements IPrecipitation {
    public WeatherRain(int id, @NotNull String languageKey, @NotNull WeatherConfig weatherConfig) {
        super(id, languageKey, weatherConfig);
    }

    @Override
    public float @NotNull [] modifyFogColor(float r, float g, float b, float intensity) {
        float rgMod = 1.0f - intensity * 0.5f;
        float bMod = 1.0f - intensity * 0.4f;
        return new float[]{r * rgMod, g * rgMod, b * bMod};
    }

    @Override
    @NotNull
    public IPrecipitation.Type getPrecipitationType() {
        return IPrecipitation.Type.RAIN_LIKE;
    }

    @Override
    @NotNull
    public String getPrecipitationTexturePath(float power, float intensity) {
        return "/assets/minecraft/textures/environment/rain.png";
    }

    @Override
    public boolean spawnRainParticles() {
        return true;
    }
}

