/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.biome.Biome;
import org.useless.seedviewer.data.ViewerBiome;

public class BTABiome
implements ViewerBiome {
    private final Biome biome;

    public BTABiome(Biome biome) {
        this.biome = biome;
    }

    @Override
    public String getName() {
        if (this.biome == null) {
            return "Unknown";
        }
        return I18n.getInstance().translateKey(this.biome.translationKey);
    }

    @Override
    public NamespaceID getID() {
        try {
            return (NamespaceID)NamespaceID.fromPool(Registries.BIOMES.getKey(this.biome)).copyUnpooled();
        }
        catch (HardIllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getColor() {
        if (this.biome == null) {
            return 0;
        }
        return this.biome.color;
    }
}

