/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.minecraft.core.Global;
import org.useless.seedviewer.data.ViewerBiome;
import org.useless.seedviewer.gui.SeedViewer;

public class InfoPanel
extends JPanel {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final SeedViewer seedViewer;
    public JLabel titleLabel;
    public JLabel btaLabel;
    public JLabel seedLabel;
    public JLabel viewLabel;
    public JLabel zoomLabel;
    public JLabel biomeLabel;
    public JLabel worldNameLabel;
    public JLabel worldSeedLabel;
    public JLabel worldPlayedLabel;
    public List<Component> resizeList = new ArrayList<Component>();

    public InfoPanel(SeedViewer seedViewer) {
        this.seedViewer = seedViewer;
        this.setLayout(null);
        this.setBorder(new LineBorder(Color.BLACK, 1));
    }

    public void setup() {
        int textHeight = 15;
        this.titleLabel = new JLabel("Information: ");
        this.titleLabel.setSize(0, 15);
        this.add(this.titleLabel);
        try {
            Class.forName("net.minecraft.core.Global");
            this.btaLabel = new JLabel("BTA Version: " + Global.VERSION);
        }
        catch (ClassNotFoundException e) {
            this.btaLabel = new JLabel("BTA Version: Missing!");
        }
        this.add(this.btaLabel);
        this.resizeList.add(this.btaLabel);
        this.seedLabel = new JLabel("Seed: " + String.valueOf(this.seedViewer.viewport.seed));
        this.seedLabel.setSize(0, 15);
        this.seedViewer.viewport.seed.addChangeListener(newValue -> this.seedLabel.setText("Seed: " + String.valueOf(this.seedViewer.viewport.seed)));
        this.viewLabel = new JLabel(String.format("View: X:%s, Z:%s", this.seedViewer.viewport.viewX.get(), Float.valueOf(-this.seedViewer.viewport.viewZ.get().floatValue())));
        this.viewLabel.setSize(0, 15);
        this.seedViewer.viewport.viewX.addChangeListener(newValue -> this.viewLabel.setText(String.format("View: X:%.2f, Z:%.2f", this.seedViewer.viewport.viewX.get(), Float.valueOf(-this.seedViewer.viewport.viewZ.get().floatValue()))));
        this.seedViewer.viewport.viewX.addChangeListener(newValue -> {
            ViewerBiome b = this.seedViewer.viewport.getHoveredBiome();
            if (b == null) {
                this.biomeLabel.setText("Biome: null");
            } else {
                this.biomeLabel.setText(String.format("Biome: %s", b.getName()));
            }
        });
        this.seedViewer.viewport.viewZ.addChangeListener(newValue -> this.viewLabel.setText(String.format("View: X:%.2f, Z:%.2f", this.seedViewer.viewport.viewX.get(), Float.valueOf(-this.seedViewer.viewport.viewZ.get().floatValue()))));
        this.seedViewer.viewport.viewZ.addChangeListener(newValue -> {
            ViewerBiome b = this.seedViewer.viewport.getHoveredBiome();
            if (b == null) {
                this.biomeLabel.setText("Biome: null");
            } else {
                this.biomeLabel.setText(String.format("Biome: %s", b.getName()));
            }
        });
        this.zoomLabel = new JLabel("Zoom: " + String.valueOf(this.seedViewer.viewport.zoom));
        this.zoomLabel.setSize(0, 15);
        this.seedViewer.viewport.zoom.addChangeListener(newValue -> this.zoomLabel.setText("Zoom: " + String.valueOf(this.seedViewer.viewport.zoom)));
        this.biomeLabel = new JLabel("Biome: None");
        this.biomeLabel.setSize(0, 15);
        this.worldNameLabel = new JLabel();
        this.worldNameLabel.setSize(0, 15);
        this.seedViewer.viewport.world.addChangeListener(newValue -> this.worldNameLabel.setText("World: " + (this.seedViewer.viewport.world.get() == null ? "null" : this.seedViewer.viewport.world.get().getName())));
        this.seedViewer.viewport.world.addChangeListener(newValue -> {
            if (newValue != null) {
                this.onWorldOpen();
                this.seedViewer.queueResize();
            } else {
                this.onWorldClose();
                this.seedViewer.queueResize();
            }
        });
        this.worldSeedLabel = new JLabel();
        this.worldSeedLabel.setSize(0, 15);
        this.seedViewer.viewport.world.addChangeListener(newValue -> this.worldSeedLabel.setText("Seed: " + String.valueOf(this.seedViewer.viewport.world.get() == null ? "null" : Long.valueOf(this.seedViewer.viewport.world.get().getSeed()))));
        this.worldPlayedLabel = new JLabel();
        this.worldPlayedLabel.setSize(0, 15);
        this.seedViewer.viewport.world.addChangeListener(newValue -> this.worldPlayedLabel.setText("Last Played: " + (this.seedViewer.viewport.world.get() == null ? "?" : DateFormat.getDateTimeInstance().format(new Date(this.seedViewer.viewport.world.get().getLastPlayed())))));
        this.addManaged(this.seedLabel);
        this.addManaged(this.viewLabel);
        this.addManaged(this.zoomLabel);
        this.addManaged(this.biomeLabel);
        this.addManaged(this.worldNameLabel);
        this.addManaged(this.worldSeedLabel);
        this.addManaged(this.worldPlayedLabel);
        if (this.seedViewer.viewport.world.get() == null) {
            this.onWorldClose();
        } else {
            this.onWorldOpen();
        }
    }

    public void addManaged(Component c) {
        this.add(c);
        this.resizeList.add(c);
    }

    public void onWorldOpen() {
        this.worldNameLabel.setEnabled(true);
        this.worldNameLabel.setVisible(true);
        this.worldSeedLabel.setEnabled(true);
        this.worldSeedLabel.setVisible(true);
        this.worldPlayedLabel.setEnabled(true);
        this.worldPlayedLabel.setVisible(true);
        this.seedLabel.setEnabled(false);
        this.seedLabel.setVisible(false);
    }

    public void onWorldClose() {
        this.worldNameLabel.setEnabled(false);
        this.worldNameLabel.setVisible(false);
        this.worldSeedLabel.setEnabled(false);
        this.worldSeedLabel.setVisible(false);
        this.worldPlayedLabel.setEnabled(false);
        this.worldPlayedLabel.setVisible(false);
        this.seedLabel.setEnabled(true);
        this.seedLabel.setVisible(true);
    }

    public void onResize(Rectangle newDimensions) {
        this.setBounds(newDimensions.x, newDimensions.y, newDimensions.width, newDimensions.height);
        int edgePad = 5;
        int elementPad = 2;
        this.titleLabel.setBounds(5, 5, newDimensions.width - 10, this.titleLabel.getHeight());
        int lastY = this.titleLabel.getY() + this.titleLabel.getHeight() + 10;
        for (Component c : this.resizeList) {
            if (!c.isVisible()) continue;
            c.setBounds(5, lastY, newDimensions.width - 10, c.getHeight());
            lastY += c.getHeight() + 2;
        }
    }
}

