/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericPortal<T extends BlockLogicPortal>
extends BlockModelGeneric<T> {
    public final StaticBlockModel[] models = new StaticBlockModel[16];

    public BlockModelGenericPortal(@NotNull Block<T> block, @NotNull String baseKey) {
        super(block, BlockModelDispatcher.loadDataModel(baseKey + DyeColor.PURPLE.colorID));
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.models[c.blockMeta] = BlockModelDispatcher.loadDataModel(baseKey + c.colorID).asModel();
        }
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int dir = worldSource.getBlockData(tilePos) & 1;
        if (dir > 0) {
            return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        }
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.models[((BlockLogicPortal)this.block.getLogic()).fromMetadata((int)data).blockMeta];
    }
}

