/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader.framebuffer;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.client.render.shader.framebuffer.FrameBufferAttachment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.lwjgl.opengl.GL41;

public abstract class FrameBuffer {
    private final int id;
    @NotNull
    private final @NotNull Map<@NotNull AttachmentType, @NotNull FrameBufferAttachment> attachments = new Object2ObjectArrayMap<AttachmentType, FrameBufferAttachment>();
    @NotNull
    private final Vector2ic size;
    private boolean deleted = false;

    protected FrameBuffer(FrameBufferAttachment ... attachments) {
        if (attachments.length == 0) {
            throw new IllegalArgumentException("Frame buffer must have at least one attachment!");
        }
        this.size = new Vector2i(attachments[0].getSize());
        for (int i = 1; i < attachments.length; ++i) {
            if (this.size.equals(attachments[i].getSize())) continue;
            throw new IllegalArgumentException("Size mismatch between attachments 0 and " + i + "!");
        }
        int maxColorAttachments = GL41.glGetInteger(36063);
        for (FrameBufferAttachment attachment : attachments) {
            int attachmentTypeId = attachment.getAttachment();
            if (attachmentTypeId >= 36064 && attachmentTypeId < 36064 + maxColorAttachments) {
                if (this.attachments.containsKey((Object)AttachmentType.COLOR)) {
                    throw new IllegalArgumentException("Multiple color attachments!");
                }
                this.attachments.put(AttachmentType.COLOR, attachment);
            }
            if (attachmentTypeId != 36096 && attachmentTypeId != 36128 && attachmentTypeId != 33306) continue;
            if (attachmentTypeId == 36096 || attachmentTypeId == 33306) {
                if (this.attachments.containsKey((Object)AttachmentType.DEPTH)) {
                    throw new IllegalArgumentException("Multiple depth attachments!");
                }
                this.attachments.put(AttachmentType.DEPTH, attachment);
            }
            if (attachmentTypeId != 36128 && attachmentTypeId != 33306) continue;
            if (this.attachments.containsKey((Object)AttachmentType.STENCIL)) {
                throw new IllegalArgumentException("Multiple stencil attachments!");
            }
            this.attachments.put(AttachmentType.STENCIL, attachment);
        }
        this.id = GL41.glGenFramebuffers();
        for (FrameBufferAttachment attachment : attachments) {
            attachment.attachToFramebuffer(this);
        }
    }

    @Nullable
    public FrameBufferAttachment getAttachment(@NotNull AttachmentType attachmentType) {
        return this.attachments.get((Object)attachmentType);
    }

    public int getId() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        return this.id;
    }

    public void delete() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer already deleted!");
        }
        GL41.glDeleteFramebuffers(this.id);
        this.deleted = true;
        for (FrameBufferAttachment attachment : this.attachments.values()) {
            if (attachment.isDeleted()) continue;
            attachment.delete();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isComplete() {
        return GL41.glCheckFramebufferStatus(this.id) == 36053;
    }

    private void checkComplete() {
        int status = GL41.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            @NotNull String message = switch (status) {
                case 33305 -> "GL_FRAMEBUFFER_UNDEFINED: Default framebuffer does not exist!";
                case 36054 -> "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT: One or more attachment points is incomplete!";
                case 36055 -> "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: Framebuffer does not have at least one image attached!";
                case 36059 -> "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER: GL_DRAW_BUFFERi color attachment point is GL_NONE!";
                case 36060 -> "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER: GL_READ_FRAMEBUFFER color attachment point is GL_NONE!";
                case 36061 -> "GL_FRAMEBUFFER_UNSUPPORTED: Combination of attached images' formats violates implementation-dependent restrictions!";
                case 36182 -> "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: Inconsistent sampling levels between color and depth attachments!";
                case 36264 -> "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS: Inconsistent layering between color and depth attachments!";
                default -> String.format("0x%04x", status) + ": Unknown framebuffer completion error!";
            };
            throw new IllegalStateException("Tried using an incomplete frame buffer! Root cause: \"" + message + "\"");
        }
    }

    @NotNull
    public Vector2ic getSize() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        return this.size;
    }

    @NotNull
    public abstract FrameBuffer getOutputBuffer();

    public void whileBound(@NotNull Runnable runnable) {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        GL41.glBindFramebuffer(36160, this.id);
        runnable.run();
        GL41.glBindFramebuffer(36160, 0);
    }

    public final void blit() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        this.whileBound(this::checkComplete);
        this.blitInner();
    }

    public final void bind() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        this.whileBound(this::checkComplete);
        this.bindInner();
    }

    protected abstract void bindInner();

    public final void unbind() {
        if (this.deleted) {
            throw new IllegalStateException("Frame buffer deleted!");
        }
        this.whileBound(this::checkComplete);
        GL41.glBindFramebuffer(36160, 0);
    }

    protected abstract void blitInner();

    public static enum AttachmentType {
        COLOR,
        DEPTH,
        STENCIL;

    }
}

