/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.zip.DataFormatException;
import net.minecraft.core.lang.text.IntoText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.ListValueSettingNode;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;

public class EnumSettingNode<T extends Enum<T>>
extends ValueGenericSettingNode<T>
implements ListValueSettingNode<T> {
    @NotNull
    final T defaultValue;

    public EnumSettingNode(@NotNull String key, @NotNull Text name, @NotNull T defaultValue) {
        super(key, name, ((Enum)defaultValue).getDeclaringClass());
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public T getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull T value) {
        return ((IntoText)value).intoText();
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@NotNull T value) {
        return new StringTag(((Enum)value).name());
    }

    @Override
    @NotNull
    public T deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof StringTag) {
            @NotNull StringTag stringTag = (StringTag)tag;
            @NotNull String string = (String)stringTag.getValue();
            try {
                return Enum.valueOf(this.getValueClass(), string);
            }
            catch (IllegalArgumentException e) {
                throw new DataFormatException("Illegal enum value in tag!");
            }
        }
        throw new DataFormatException("Tag was wrong type!");
    }

    @Override
    @NotNull
    public List<T> getValues(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return Arrays.asList(Objects.requireNonNull((Enum[])this.getValueClass().getEnumConstants()));
    }
}

