/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

public interface CommandSource {
    public Collection<String> getPlayerUsernames();

    public Collection<String> getPlayerNicknames();

    default public Collection<String> getChatSuggestions() {
        return this.getPlayerUsernames();
    }

    default public Collection<String> getEntitySuggestions() {
        return Collections.emptyList();
    }

    public String toString();

    @Nullable
    public Player getSender();

    public boolean hasAdmin();

    @Nullable
    public Vector3dc getCoordinates(boolean var1);

    @Nullable
    public TilePosc getBlockCoordinates();

    public boolean messageMayBeMultiline();

    public void sendMessage(String var1);

    public void sendMessage(Player var1, String var2);

    default public void sendTranslatableMessage(String message, Object ... args2) {
        this.sendMessage(I18n.getInstance().translateKeyAndFormat(message, args2));
    }

    default public void sendTranslatableMessage(Player player, String message, Object ... args2) {
        this.sendMessage(player, I18n.getInstance().translateKeyAndFormat(message, args2));
    }

    public void sendMessageToAllPlayers(String var1);

    public void sendPacketToAllPlayers(Supplier<Packet> var1);

    public World getWorld();

    public World getWorld(int var1);

    public void movePlayerToDimension(Player var1, int var2);

    public void teleportPlayerToPos(Player var1, double var2, double var4, double var6);

    public void teleportPlayerToPosAndRot(Player var1, double var2, double var4, double var6, float var8, float var9);

    public String getName();
}

