/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings.gamerule;

import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.data.gamerule.GameRuleInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerGameRuleComponent
extends ButtonComponent {
    @Nullable
    private GameRuleCollection gameRuleCollection = null;
    @NotNull
    private final GameRuleInteger gameRule;
    @NotNull
    private final TextFieldElement textField;

    public IntegerGameRuleComponent(@NotNull GameRuleInteger gameRule) {
        super(gameRule.getTranslationKey() + ".name", gameRule.getTranslationKey() + ".desc");
        this.gameRule = gameRule;
        this.textField = new TextFieldElement(IntegerGameRuleComponent.mc.currentScreen, IntegerGameRuleComponent.mc.font, 0, 0, 150, 20, ((Integer)this.gameRule.getDefaultValue()).toString(), null);
    }

    public void setGameRuleCollection(@NotNull GameRuleCollection collection) {
        this.gameRuleCollection = collection;
    }

    @Override
    public void resetValue() {
        assert (this.gameRuleCollection != null);
        this.gameRuleCollection.setValue(this.gameRule, (Integer)this.gameRule.getDefaultValue());
        this.onChange();
    }

    @Override
    public boolean isDefault() {
        assert (this.gameRuleCollection != null);
        return this.gameRuleCollection.getValue(this.gameRule).equals(this.gameRule.getDefaultValue());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
    }

    protected void onChange() {
        assert (this.gameRuleCollection != null);
        this.textField.setText(this.gameRuleCollection.getValue(this.gameRule).toString());
    }
}

