/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.client.render.tessellator.TessellatorLOD;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorLODShader
implements TessellatorLOD {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public LODVertexData data;
    public boolean drawing = false;
    @NotNull
    private final Vector3d offset = new Vector3d();
    private static final int MASK_BOTTOM = 1;
    private static final int MASK_TOP = 2;
    private static final int MASK_NORTH = 4;
    private static final int MASK_SOUTH = 8;
    private static final int MASK_WEST = 16;
    private static final int MASK_EAST = 32;

    public TessellatorLODShader(int size) {
        this.data = new LODVertexData(size);
    }

    private void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }

    @Override
    public void startDrawingLOD() {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        this.drawing = true;
        this.data.vertexCount = 0;
    }

    @Override
    public boolean addLOD(double x, double y, double z, float r, float g, float b, boolean minX, boolean maxX, boolean minY, boolean maxY, boolean minZ, boolean maxZ) {
        this.checkIsDrawing();
        return minX || minY || minZ || maxX || maxY || maxZ;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.z = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offset.x += x;
        this.offset.y += y;
        this.offset.z += z;
    }

    public static class LODVertexData
    extends VertexData<LODVertexConfig> {
        public LODVertexData(int size) {
            super(new LODVertexConfig(), size);
        }
    }

    public static class LODVertexConfig
    implements VertexConfig<LODVertexConfig> {
        @Override
        @NotNull
        public DrawMode drawMode() {
            return DrawMode.POINTS;
        }

        @Override
        public void enable(int vao, int vbo) {
            GL41.glBindVertexArray(vao);
            GL41.glBindBuffer(34962, vbo);
            int offset = 0;
            int vertexSize = 28;
            GL41.glVertexAttribPointer(0, 3, 5126, false, 28, offset);
            GL41.glVertexAttribPointer(1, 3, 5126, false, 28, offset += 12);
            GL41.glVertexAttribPointer(2, 1, 5125, false, 28, offset += 12);
            offset += 4;
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glEnableVertexAttribArray(2);
        }

        @Override
        public void disable() {
            GL41.glDisableVertexAttribArray(0);
            GL41.glDisableVertexAttribArray(1);
            GL41.glDisableVertexAttribArray(2);
            GL41.glBindBuffer(34962, 0);
            GL41.glBindVertexArray(0);
        }

        @Override
        public int getVertexSize() {
            return 28;
        }

        @Override
        @NotNull
        public LODVertexConfig copy() {
            return this;
        }

        public boolean equals(Object obj) {
            return obj instanceof LODVertexConfig;
        }
    }
}

