/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkLoader;
import net.minecraft.core.world.chunk.provider.ChunkProviderThreaded;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPosc;
import org.jetbrains.annotations.NotNull;

public class ChunkProviderThreadedClient
extends ChunkProviderThreaded {
    public ChunkProviderThreadedClient(@NotNull World world, @NotNull ChunkLoader chunkLoader, @NotNull ChunkGenerator chunkGenerator) {
        super(world, chunkLoader, chunkGenerator);
    }

    @Override
    protected boolean isChunkValid(@NotNull ChunkPosc chunkPos) {
        PlayerLocal player;
        Minecraft mc = Minecraft.getMinecraft();
        int rd = this.world.renderDistance() + 1;
        if (this.chunkOver != null) {
            int dx = this.chunkOver.x - chunkPos.x();
            int dz = this.chunkOver.z - chunkPos.z();
            if (dx <= 2 && dx >= -2 && dz <= 2 && dz >= -2) {
                return true;
            }
        }
        if ((player = mc.thePlayer) != null) {
            int pCX = (int)player.x >> 4;
            int pCZ = (int)player.z >> 4;
            int dx = pCX - chunkPos.x();
            int dz = pCZ - chunkPos.z();
            return dx <= rd && dx >= -rd && dz <= rd && dz >= -rd;
        }
        return false;
    }
}

