#version 410
out vec4 FragColor;
in vec2 TexCoords;

uniform sampler2D colortex0;

uniform float width;
uniform float height;
uniform float intensity;


vec3 getBlur(){
	vec3 blur = vec3(0.0);
	int q = int(16 * intensity);
	float qh = q / 2.0 - 0.5;
	float allStrengths = 0.0;
	
	vec2 pixel = vec2(1.0 / width, 1.0 / height);
	for(int i=0; i < q; i++){
		for(int j=0; j < q; j++){
			float strength = 1 - sin(length(vec2(i - qh, j - qh)) / qh);
			
			blur += texture(colortex0, TexCoords + vec2(i - qh, j - qh) * pixel).rgb * strength;
			
			allStrengths += strength;
		}
	}
	blur /= allStrengths;
	return blur;
}

void main(){
	vec3 color = texture(colortex0, TexCoords).rgb;

	float blurFactor = clamp(distance(TexCoords, vec2(0.5)) * 1.0, 0.0, 1.0);
	vec3 blur = getBlur();

	//Apply Blur
	if (int(16 * intensity) > 1)
	{
		color = mix(color, blur, blurFactor);
	}


	//Bloom
	//color = color * 0.93 + clamp(pow(blur, vec3(2.0)), 0.0, 1.0) * 0.4;
	
	FragColor = vec4(color, 1.0);
}