/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.phys;

import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class HitResult {
    @NotNull
    public final Vector3dc location;

    public HitResult(double x, double y, double z) {
        this.location = new Vector3d(x, y, z);
    }

    public HitResult(@NotNull Vector3dc location) {
        this.location = new Vector3d(location);
    }

    public double distanceToSquared(@NotNull net.minecraft.core.entity.Entity entity) {
        double diffX = this.location.x() - entity.x;
        double diffY = this.location.y() - entity.y;
        double diffZ = this.location.z() - entity.z;
        return diffX * diffX + diffY * diffY + diffZ * diffZ;
    }

    public double distanceTo(@NotNull net.minecraft.core.entity.Entity entity) {
        return Math.sqrt(this.distanceToSquared(entity));
    }

    public static final class Clip
    extends HitResult {
        @NotNull
        public final Side side;

        public Clip(@NotNull Side side, @NotNull Vector3dc location) {
            super(location);
            this.side = side;
        }
    }

    public static final class Entity
    extends HitResult {
        @NotNull
        public final net.minecraft.core.entity.Entity entity;

        public Entity(@NotNull net.minecraft.core.entity.Entity entity) {
            super(entity.x, entity.y, entity.z);
            this.entity = entity;
        }
    }

    public static final class Tile
    extends HitResult {
        @NotNull
        public final TilePosc tilePos;
        @NotNull
        public final Side side;

        public Tile(@NotNull TilePosc tilePos, @NotNull Side side, @NotNull Vector3dc location) {
            super(location);
            this.tilePos = new TilePos(tilePos);
            this.side = side;
        }
    }
}

