/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class WorldFeatureTerrace
extends WorldFeature {
    @NotNull
    private final Block<?> fillBlock;
    @NotNull
    private final Block<?> wallBlock;
    private final int minRadius;
    private final int radiusMod;

    public WorldFeatureTerrace(@NotNull Block<?> fillBlock, @NotNull Block<?> wallBlock) {
        this.fillBlock = fillBlock;
        this.wallBlock = wallBlock;
        this.minRadius = 6;
        this.radiusMod = 6;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int radius = this.minRadius + random.nextInt(this.radiusMod);
        TilePos centerPos = new TilePos(x + random.nextInt(8), y, z + random.nextInt(8));
        TilePos cursor = new TilePos();
        TilePos queryPos = new TilePos();
        cursor.x = centerPos.x() - radius;
        while (cursor.x <= centerPos.x() + radius) {
            cursor.z = centerPos.z() - radius;
            while (cursor.z <= centerPos.z() + radius) {
                int xd = cursor.x() - centerPos.x();
                int zd = cursor.z() - centerPos.z();
                float dist = xd * xd + zd * zd;
                cursor.y = world.getWorldType().getMaxY(world);
                while (cursor.y > world.getWorldType().getOceanY() + 4) {
                    if (!world.isAirBlock(cursor)) {
                        if (dist <= (float)(radius * radius) && this.canPlaceWall(cursor, queryPos, world)) {
                            world.setBlockTypeNotify(cursor, this.wallBlock);
                        }
                        if (dist <= (float)((radius - 1) * (radius - 1)) && this.canPlacePool(cursor, queryPos, world)) {
                            world.setBlockTypeNotify(cursor, this.fillBlock);
                        }
                    }
                    --cursor.y;
                }
                ++cursor.z;
            }
            ++cursor.x;
        }
        return true;
    }

    private boolean canPlaceWall(TilePos cursor, TilePos query, World world) {
        cursor.add(Direction.UP, query);
        if (!world.isAirBlock(query)) {
            return false;
        }
        return world.getBlockType(cursor).hasTag(BlockTags.NETHER_SURFACE_BLOCK);
    }

    private boolean canPlacePool(TilePos cursor, TilePos query, World world) {
        if (!world.getBlockType(cursor).hasTag(BlockTags.NETHER_SURFACE_BLOCK)) {
            return false;
        }
        for (Direction dir : Direction.directions) {
            cursor.add(dir, query);
            if (!(dir == Direction.UP ? !world.isAirBlock(query) : world.isAirBlock(query) || !world.getBlockType(cursor).hasTag(BlockTags.NETHER_SURFACE_BLOCK))) continue;
            return false;
        }
        return true;
    }
}

