/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.SettingNodesValues;
import net.minecraft.core.world.settings.WorldSettingNodes;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldConfiguration
implements WorldConfigurationReader {
    @NotNull
    private String worldName = "";
    private long numericSeed = new Random().nextLong();
    @NotNull
    private String stringSeed = "";
    private boolean cheatsEnabled = false;
    @NotNull
    private Gamemode gamemode = Gamemodes.SURVIVAL;
    @NotNull
    private WorldTypeGroups.Group worldTypeGroup = WorldTypeGroups.DEFAULT;
    @NotNull
    private final GameRuleCollection gameRuleCollection = new GameRuleCollection();
    @NotNull
    private final SpawnerConfig spawnerConfig = new SpawnerConfig();
    @NotNull
    private final @NotNull Map<@NotNull Dimension, @NotNull SettingNodesValues> worldSettings = new Object2ObjectArrayMap<Dimension, SettingNodesValues>();
    @Nullable
    private ChangeListener changeListener;

    public WorldConfiguration() {
        for (Dimension dimension : Dimension.getDimensionList().values()) {
            this.worldSettings.put(dimension, new SettingNodesValues(WorldSettingNodes.getRootNode(), dimension));
        }
    }

    public void setChangeListener(@Nullable ChangeListener changeListener) {
        this.changeListener = changeListener;
        this.gameRuleCollection.setChangeListener(this.changeListener);
        this.spawnerConfig.setChangeListener(this.changeListener);
        for (SettingNodesValues values2 : this.worldSettings.values()) {
            values2.setChangeListener(this.changeListener);
        }
    }

    private void notifyChanged() {
        if (this.changeListener != null) {
            this.changeListener.onChanged();
        }
    }

    @NotNull
    public WorldConfiguration copy() {
        @NotNull WorldConfiguration copy = new WorldConfiguration();
        copy.setWorldName(this.worldName);
        copy.setNumericSeed(this.numericSeed);
        copy.setStringSeed(this.stringSeed);
        copy.setCheatsEnabled(this.cheatsEnabled);
        copy.setGamemode(this.gamemode);
        copy.setWorldTypeGroup(this.worldTypeGroup);
        copy.gameRuleCollection.setValues(this.gameRuleCollection);
        copy.spawnerConfig.set(this.spawnerConfig);
        for (Dimension key : this.worldSettings.keySet()) {
            @NotNull SettingNodesValues values2 = Objects.requireNonNull(this.worldSettings.get(key));
            Objects.requireNonNull(copy.worldSettings.get(key)).setAll(values2);
        }
        return copy;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    @NotNull
    public String getFinalWorldName() {
        if (MathHelper.stringNullOrLengthZero(this.worldName)) {
            return I18n.getInstance().translateKey("gui.create_world.label.new_world");
        }
        return this.worldName;
    }

    public void setWorldName(@NotNull String worldName) {
        this.worldName = worldName;
        this.notifyChanged();
    }

    public long getNumericSeed() {
        return this.numericSeed;
    }

    @Override
    public long getFinalNumericSeed() {
        if (MathHelper.stringNullOrLengthZero(this.stringSeed)) {
            return this.numericSeed;
        }
        try {
            long parsedSeed = Long.parseLong(this.stringSeed);
            if (parsedSeed != 0L) {
                return parsedSeed;
            }
        }
        catch (NumberFormatException e) {
            return this.stringSeed.hashCode();
        }
        return this.numericSeed;
    }

    public void regenNumericSeed() {
        this.numericSeed = new Random().nextLong();
        this.notifyChanged();
    }

    public void setNumericSeed(long seed) {
        this.numericSeed = seed;
        this.notifyChanged();
    }

    @NotNull
    public String getStringSeed() {
        return this.stringSeed;
    }

    public void setStringSeed(@NotNull String seed) {
        this.stringSeed = seed;
        this.notifyChanged();
    }

    @Override
    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean cheatsEnabled) {
        this.cheatsEnabled = cheatsEnabled;
        this.notifyChanged();
    }

    @NotNull
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(@NotNull Gamemode gamemode) {
        this.gamemode = gamemode;
        this.notifyChanged();
    }

    @NotNull
    public WorldTypeGroups.Group getWorldTypeGroup() {
        return this.worldTypeGroup;
    }

    @Override
    @NotNull
    public WorldType getWorldType(@NotNull Dimension dimension) {
        return this.worldTypeGroup.get(dimension);
    }

    public void setWorldTypeGroup(@NotNull WorldTypeGroups.Group worldTypeGroup) {
        this.worldTypeGroup = worldTypeGroup;
        this.notifyChanged();
    }

    @Override
    @NotNull
    public GameRuleCollection getGameRules() {
        return this.gameRuleCollection;
    }

    @Override
    @NotNull
    public SpawnerConfig getSpawnerConfig() {
        return this.spawnerConfig;
    }

    @Override
    @NotNull
    public SettingNodesValues getDimensionSettings(@NotNull Dimension dimension) {
        return Objects.requireNonNull(this.worldSettings.get(dimension));
    }

    @NotNull
    public String getFolderName(@NotNull ISaveFormat saveFormat) {
        char @NotNull [] ac = ChatAllowedCharacters.ALLOWED_CHARACTERS_ARRAY;
        @NotNull Object folderName = this.worldName.trim();
        if (MathHelper.stringNullOrLengthZero((String)folderName)) {
            folderName = I18n.getInstance().translateKey("gui.create_world.label.new_world");
        }
        for (char c : ac) {
            folderName = ((String)folderName).replace(c, '_');
        }
        String fixedFolderName = folderName;
        int count = 1;
        while (saveFormat.getLevelData((String)folderName) != null) {
            folderName = fixedFolderName + " (" + count + ")";
            ++count;
        }
        return folderName;
    }

    public static interface ChangeListener {
        public void onChanged();
    }
}

